/*
 * Decompiled with CFR 0.152.
 */
package io.crate.beans;

import io.crate.beans.NodeInfoMXBean;
import io.crate.beans.ShardInfo;
import io.crate.beans.ShardStats;
import io.crate.common.collections.Tuple;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;

public class NodeInfo
implements NodeInfoMXBean {
    public static final String NAME = "io.crate.monitoring:type=NodeInfo";
    private final Supplier<ClusterState> clusterState;
    private final Function<ShardId, Tuple<IndexShardState, Long>> shardStateAndSizeProvider;

    public NodeInfo(Supplier<ClusterState> clusterState, Function<ShardId, Tuple<IndexShardState, Long>> shardStateAndSizeProvider) {
        this.clusterState = clusterState;
        this.shardStateAndSizeProvider = shardStateAndSizeProvider;
    }

    @Override
    public String getNodeId() {
        return this.clusterState.get().nodes().getLocalNodeId();
    }

    @Override
    public String getNodeName() {
        return this.clusterState.get().nodes().getLocalNode().getName();
    }

    @Override
    public long getClusterStateVersion() {
        return this.clusterState.get().version();
    }

    @Override
    public ShardStats getShardStats() {
        int total = 0;
        int replicas = 0;
        int unassigned = 0;
        int primaries = 0;
        ClusterState cs = this.clusterState.get();
        String localNodeId = cs.nodes().getLocalNodeId();
        boolean isMasterNode = cs.nodes().isLocalNodeElectedMaster();
        for (ShardRouting shardRouting : NodeInfo.shardsForOpenIndices(cs)) {
            if (localNodeId.equals(shardRouting.currentNodeId())) {
                ++total;
                if (shardRouting.primary()) {
                    ++primaries;
                    continue;
                }
                ++replicas;
                continue;
            }
            if (!isMasterNode || !shardRouting.unassigned()) continue;
            ++unassigned;
        }
        return new ShardStats(total, primaries, replicas, unassigned);
    }

    @Override
    public List<ShardInfo> getShardInfo() {
        ClusterState cs = this.clusterState.get();
        String localNodeId = cs.nodes().getLocalNodeId();
        ArrayList<ShardInfo> result = new ArrayList<ShardInfo>();
        for (ShardRouting shardRouting : NodeInfo.shardsForOpenIndices(cs)) {
            Tuple<IndexShardState, Long> shardStateAndSize;
            ShardId shardId = shardRouting.shardId();
            if (!localNodeId.equals(shardRouting.currentNodeId()) || (shardStateAndSize = this.shardStateAndSizeProvider.apply(shardId)) == null) continue;
            IndexParts indexParts = IndexName.decode((String)shardId.getIndexName());
            result.add(new ShardInfo(shardId.id(), indexParts.schema(), indexParts.table(), indexParts.partitionIdent(), shardRouting.state().name(), ((IndexShardState)shardStateAndSize.v1()).name(), (Long)shardStateAndSize.v2()));
        }
        return result;
    }

    private static Iterable<ShardRouting> shardsForOpenIndices(ClusterState clusterState) {
        String[] concreteIndices = (String[])Arrays.stream(clusterState.metadata().getConcreteAllOpenIndices()).filter(index -> !IndexName.isDangling((String)index)).toArray(String[]::new);
        return clusterState.routingTable().allShards(concreteIndices);
    }

    public static class ShardStateAndSizeProvider
    implements Function<ShardId, Tuple<IndexShardState, Long>> {
        private final IndicesService indicesService;

        public ShardStateAndSizeProvider(IndicesService indicesService) {
            this.indicesService = indicesService;
        }

        @Override
        public Tuple<IndexShardState, Long> apply(ShardId shardId) {
            IndexShard shard = (IndexShard)this.indicesService.getShardOrNull(shardId);
            if (shard == null) {
                return null;
            }
            return new Tuple((Object)shard.state(), (Object)shard.storeStats().getSizeInBytes());
        }
    }
}

