/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.azure;

import io.crate.copy.azure.AzureURI;
import io.crate.copy.azure.OperatorHelper;
import io.crate.copy.azure.SharedAsyncExecutor;
import io.crate.execution.engine.collect.files.FileInput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.opendal.AsyncExecutor;
import org.apache.opendal.AsyncOperator;
import org.apache.opendal.Entry;
import org.apache.opendal.Operator;
import org.elasticsearch.common.settings.Settings;

public class AzureFileInput
implements FileInput {
    private final Map<String, String> config;
    private final AzureURI azureURI;
    private final URI uri;
    private final Operator operator;

    public AzureFileInput(SharedAsyncExecutor sharedAsyncExecutor, URI uri, Settings settings) {
        this.azureURI = AzureURI.of(uri);
        this.config = OperatorHelper.config(this.azureURI, settings, true);
        this.operator = AsyncOperator.of((String)"azblob", this.config, (AsyncExecutor)sharedAsyncExecutor.asyncExecutor()).blocking();
        String resourceURI = this.azureURI.resourcePath();
        this.uri = URI.create(resourceURI);
    }

    public List<URI> expandUri() throws IOException {
        if (!this.isGlobbed()) {
            return List.of(this.uri);
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        String preGlobPath = this.azureURI.preGlobPath();
        assert (preGlobPath != null) : "List API must be used only for a globbed URI.";
        List entries = this.operator.list(preGlobPath);
        for (Entry entry : entries) {
            String path = entry.getPath();
            if (!this.azureURI.matchesGlob(path)) continue;
            uris.add(URI.create(path));
        }
        return uris;
    }

    public InputStream getStream(URI uri) throws IOException {
        return this.operator.createInputStream(uri.getPath());
    }

    public boolean isGlobbed() {
        return this.azureURI.preGlobPath() != null;
    }

    public URI uri() {
        return this.uri;
    }

    public boolean sharedStorageDefault() {
        return true;
    }

    public void close() {
        assert (this.operator != null) : "Operator must be created before FileInput is closed";
        this.operator.close();
    }
}

