/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.microsoft.azure.storage.LocationMode;
import io.crate.common.unit.TimeValue;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.azure.AzureBlobStore;
import org.elasticsearch.repositories.azure.AzureStorageService;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.jetbrains.annotations.VisibleForTesting;

public class AzureRepository
extends BlobStoreRepository {
    private static final Logger LOGGER = LogManager.getLogger(AzureRepository.class);
    public static final String TYPE = "azure";
    private final ByteSizeValue chunkSize;
    private final boolean readonly;

    public static List<Setting<?>> optionalSettings() {
        return List.of(Repository.CONTAINER_SETTING, Repository.BASE_PATH_SETTING, Repository.CHUNK_SIZE_SETTING, Repository.READONLY_SETTING, Repository.LOCATION_MODE_SETTING, COMPRESS_SETTING, Repository.MAX_RETRIES_SETTING, Repository.ENDPOINT_SETTING, Repository.SECONDARY_ENDPOINT_SETTING, Repository.ENDPOINT_SUFFIX_SETTING, Repository.TIMEOUT_SETTING, Repository.PROXY_TYPE_SETTING, Repository.PROXY_HOST_SETTING, Repository.PROXY_PORT_SETTING, Repository.KEY_SETTING, Repository.SAS_TOKEN_SETTING);
    }

    public static List<Setting<?>> mandatorySettings() {
        return List.of(Repository.ACCOUNT_SETTING);
    }

    public AzureRepository(RepositoryMetadata metadata, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        super(metadata, namedWriteableRegistry, namedXContentRegistry, clusterService, recoverySettings, AzureRepository.buildBasePath(metadata));
        this.chunkSize = (ByteSizeValue)Repository.CHUNK_SIZE_SETTING.get(metadata.settings());
        LocationMode locationMode = (LocationMode)Repository.LOCATION_MODE_SETTING.get(metadata.settings());
        this.readonly = Repository.READONLY_SETTING.exists(metadata.settings()) ? (Boolean)Repository.READONLY_SETTING.get(metadata.settings()) : locationMode == LocationMode.SECONDARY_ONLY;
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = Strings.trimLeadingCharacter((String)((String)Repository.BASE_PATH_SETTING.get(metadata.settings())), (char)'/');
        if (Strings.hasLength((CharSequence)basePath)) {
            BlobPath path = new BlobPath();
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            return path;
        }
        return BlobPath.cleanPath();
    }

    @VisibleForTesting
    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    protected AzureBlobStore createBlobStore() {
        AzureBlobStore blobStore = new AzureBlobStore(this.metadata);
        LOGGER.debug(() -> new ParameterizedMessage("using container [{}], chunk_size [{}], compress [{}], base_path [{}]", new Object[]{blobStore, this.chunkSize, this.isCompress(), this.basePath()}));
        return blobStore;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public static final class Repository {
        static final Setting<SecureString> SAS_TOKEN_SETTING = Setting.maskedString((String)"sas_token");
        static final Setting<SecureString> ACCOUNT_SETTING = Setting.maskedString((String)"account");
        static final Setting<SecureString> KEY_SETTING = Setting.maskedString((String)"key");
        static final Setting<String> CONTAINER_SETTING = new Setting("container", "crate-snapshots", Function.identity(), (DataType)DataTypes.STRING, new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<LocationMode> LOCATION_MODE_SETTING = new Setting("location_mode", s -> LocationMode.PRIMARY_ONLY.toString(), s -> LocationMode.valueOf((String)s.toUpperCase(Locale.ROOT)), (DataType)DataTypes.STRING, new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MIN_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<Boolean> READONLY_SETTING = Setting.boolSetting((String)"readonly", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<Integer> MAX_RETRIES_SETTING = Setting.intSetting((String)"max_retries", (int)3, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<String> ENDPOINT_SETTING = Setting.simpleString((String)"endpoint", val -> Repository.validateEndpoint(val, "endpoint"), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<String> SECONDARY_ENDPOINT_SETTING = Setting.simpleString((String)"secondary_endpoint", val -> Repository.validateEndpoint(val, "secondary_endpoint"), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<String> ENDPOINT_SUFFIX_SETTING = Setting.simpleString((String)"endpoint_suffix", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<TimeValue> TIMEOUT_SETTING = Setting.timeSetting((String)"timeout", (TimeValue)TimeValue.timeValueMinutes((long)-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<Proxy.Type> PROXY_TYPE_SETTING = new Setting("proxy_type", "direct", s -> Proxy.Type.valueOf(s.toUpperCase(Locale.ROOT)), (DataType)DataTypes.STRING, new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<String> PROXY_HOST_SETTING = Setting.simpleString((String)"proxy_host", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        static final Setting<Integer> PROXY_PORT_SETTING = Setting.intSetting((String)"proxy_port", (int)0, (int)0, (int)65535, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

        private static void validateEndpoint(String endpoint, String settingName) {
            if (Strings.isNullOrEmpty((CharSequence)endpoint)) {
                return;
            }
            try {
                URI uri = new URI(endpoint);
                if (uri.getScheme() == null || uri.getHost() == null) {
                    throw new ElasticsearchParseException("Invalid " + settingName + " URI: " + endpoint, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("Invalid " + settingName + " URI: " + endpoint, (Throwable)e, new Object[0]);
            }
        }
    }
}

