/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.opendal.Environment;
import org.apache.opendal.NativeObject;

public final class NativeLibrary {
    private static final AtomicReference<LibraryState> libraryLoaded = new AtomicReference<LibraryState>(LibraryState.NOT_LOADED);

    public static void loadLibrary() {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            try {
                NativeLibrary.doLoadLibrary();
            }
            catch (IOException e) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw new UncheckedIOException("Unable to load the OpenDAL shared library", e);
            }
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void doLoadLibrary() throws IOException {
        try {
            System.loadLibrary("opendal_java");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            NativeLibrary.doLoadBundledLibrary();
            return;
        }
    }

    private static void doLoadBundledLibrary() throws IOException {
        String libraryPath = NativeLibrary.bundledLibraryPath();
        try (InputStream is = NativeObject.class.getResourceAsStream(libraryPath);){
            if (is == null) {
                throw new IOException("cannot find " + libraryPath);
            }
            int dot = libraryPath.indexOf(46);
            File tmpFile = File.createTempFile(libraryPath.substring(0, dot), libraryPath.substring(dot));
            tmpFile.deleteOnExit();
            Files.copy(is, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.load(tmpFile.getAbsolutePath());
        }
    }

    private static String bundledLibraryPath() {
        String classifier = Environment.getClassifier();
        String libraryName = System.mapLibraryName("opendal_java");
        return "/native/" + classifier + "/" + libraryName;
    }

    @Generated
    private NativeLibrary() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        NativeLibrary.loadLibrary();
    }

    private static enum LibraryState {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

