/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.Expression;
import java.util.Objects;

public abstract class AbstractCast
extends Expression {
    private final Expression expression;
    private final ColumnType<?> type;
    private final boolean isIntegerOnly;

    protected AbstractCast(Expression expression, ColumnType<?> type) {
        this(expression, type, false);
    }

    protected AbstractCast(Expression expression, ColumnType<?> type, boolean isIntegerOnly) {
        this.expression = expression;
        this.type = type;
        this.isIntegerOnly = isIntegerOnly;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ColumnType<?> getType() {
        return this.type;
    }

    public boolean isIntegerOnly() {
        return this.isIntegerOnly;
    }

    @Override
    public abstract <R, C> R accept(AstVisitor<R, C> var1, C var2);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCast cast = (AbstractCast)o;
        return Objects.equals(this.expression, cast.expression) && Objects.equals(this.type, cast.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.type);
    }
}

