/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CreateSnapshot<T>
extends Statement {
    private final QualifiedName name;
    private final GenericProperties<T> properties;
    private final List<Table<T>> tables;

    public CreateSnapshot(QualifiedName name, GenericProperties<T> properties) {
        this.name = name;
        this.properties = properties;
        this.tables = Collections.emptyList();
    }

    public CreateSnapshot(QualifiedName name, List<Table<T>> tables, GenericProperties<T> properties) {
        this.name = name;
        this.tables = tables;
        this.properties = properties;
    }

    public QualifiedName name() {
        return this.name;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    public List<Table<T>> tables() {
        return this.tables;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSnapshot that = (CreateSnapshot)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.properties, that.properties) && Objects.equals(this.tables, that.tables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.properties, this.tables);
    }

    @Override
    public String toString() {
        return "CreateSnapshot{name=" + String.valueOf(this.name) + ", properties=" + String.valueOf(this.properties) + ", tables=" + String.valueOf(this.tables) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateSnapshot(this, context);
    }
}

