/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Statement;
import java.util.Objects;

public final class Fetch
extends Statement {
    private final ScrollMode scrollMode;
    private final long count;
    private final String cursorName;

    public Fetch(ScrollMode scollMode, long count, String cursorName) {
        this.scrollMode = scollMode;
        this.count = count;
        this.cursorName = cursorName;
    }

    public ScrollMode scrollMode() {
        return this.scrollMode;
    }

    public long count() {
        return this.count;
    }

    public String cursorName() {
        return this.cursorName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFetch(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.count, this.cursorName, this.scrollMode});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fetch other = (Fetch)obj;
        return this.count == other.count && Objects.equals(this.cursorName, other.cursorName) && this.scrollMode == other.scrollMode;
    }

    @Override
    public String toString() {
        return "Fetch{count=" + this.count + ", cursorName=" + this.cursorName + ", scrollMode=" + String.valueOf((Object)this.scrollMode) + "}";
    }

    public static enum ScrollMode {
        MOVE,
        RELATIVE,
        ABSOLUTE;

    }
}

