/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Window;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class FunctionCall
extends Expression {
    private final QualifiedName name;
    private final boolean distinct;
    private final List<Expression> arguments;
    private final Optional<Window> window;
    private final Optional<Expression> filter;
    @Nullable
    private final Boolean ignoreNulls;

    public FunctionCall(QualifiedName name, List<Expression> arguments) {
        this(name, false, arguments, Optional.empty(), Optional.empty(), null);
    }

    public FunctionCall(QualifiedName name, boolean distinct, List<Expression> arguments, Optional<Window> window, Optional<Expression> filter, @Nullable Boolean ignoreNulls) {
        this.name = name;
        this.distinct = distinct;
        this.arguments = arguments;
        this.window = window;
        this.filter = filter;
        this.ignoreNulls = ignoreNulls;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public Optional<Window> getWindow() {
        return this.window;
    }

    public Optional<Expression> filter() {
        return this.filter;
    }

    @Nullable
    public Boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionCall that = (FunctionCall)o;
        return this.distinct == that.distinct && Objects.equals(this.name, that.name) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.window, that.window) && Objects.equals(this.filter, that.filter) && Objects.equals(this.ignoreNulls, that.ignoreNulls);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.distinct, this.arguments, this.window, this.filter, this.ignoreNulls);
    }
}

