/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class GenericProperties<T>
extends Node
implements Iterable<Map.Entry<String, T>> {
    private static final GenericProperties<?> EMPTY = new GenericProperties(Map.of());
    private final Map<String, T> properties;

    public static <T> GenericProperties<T> empty() {
        return EMPTY;
    }

    public GenericProperties(Map<String, T> map) {
        this.properties = Collections.unmodifiableMap(map);
    }

    public void forValues(Consumer<? super T> action) {
        this.properties.values().forEach(action);
    }

    @Nullable
    public T get(String key) {
        return this.properties.get(key);
    }

    @Nullable
    public <U> U getUnsafe(String key) {
        return (U)this.properties.get(key);
    }

    @Nullable
    public T get(String key, T defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<String, T>> iterator() {
        return this.properties.entrySet().iterator();
    }

    public Stream<Map.Entry<String, T>> stream() {
        return this.properties.entrySet().stream();
    }

    public Map<String, T> toMap(Supplier<Map<String, T>> newMap) {
        Map<String, T> result = newMap.get();
        result.putAll(this.properties);
        return result;
    }

    public <U> GenericProperties<U> map(Function<? super T, ? extends U> mapper) {
        if (this.isEmpty()) {
            return GenericProperties.empty();
        }
        HashMap mappedProperties = new HashMap(this.properties.size());
        this.properties.forEach((? super K key, ? super V value) -> mappedProperties.put(key, mapper.apply(value)));
        return new GenericProperties(mappedProperties);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericProperties that = (GenericProperties)o;
        return Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.properties);
    }

    @Override
    public String toString() {
        return this.properties.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGenericProperties(this, context);
    }

    public int size() {
        return this.properties.size();
    }

    public Set<String> keys() {
        return this.properties.keySet();
    }

    public GenericProperties<T> ensureContainsOnly(Collection<String> supportedSettings) {
        for (String key : this.properties.keySet()) {
            if (supportedSettings.contains(key)) continue;
            throw new IllegalArgumentException("Setting '" + key + "' is not supported");
        }
        return this;
    }
}

