/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.TableElement;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class IndexDefinition<T>
extends TableElement<T> {
    private final String ident;
    private final String method;
    private final List<T> columns;
    private final GenericProperties<T> properties;

    public IndexDefinition(String ident, String method, List<T> columns, GenericProperties<T> properties) {
        this.ident = ident;
        this.method = method;
        this.columns = columns;
        this.properties = properties;
    }

    public String ident() {
        return this.ident;
    }

    public String method() {
        return this.method;
    }

    public List<T> columns() {
        return this.columns;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexDefinition that = (IndexDefinition)o;
        return Objects.equals(this.ident, that.ident) && Objects.equals(this.method, that.method) && Objects.equals(this.columns, that.columns) && Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ident, this.method, this.columns, this.properties);
    }

    @Override
    public String toString() {
        return "IndexDefinition{ident='" + this.ident + "', method='" + this.method + "', columns=" + String.valueOf(this.columns) + ", properties=" + String.valueOf(this.properties) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIndexDefinition(this, context);
    }

    @Override
    public void visit(Consumer<? super T> consumer) {
        this.columns.forEach(consumer);
        this.properties.forValues(consumer);
    }
}

