/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ColumnType;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class ObjectColumnType<T>
extends ColumnType<T> {
    private final Optional<ColumnPolicy> columnPolicy;
    private final List<ColumnDefinition<T>> nestedColumns;

    public ObjectColumnType(@Nullable ColumnPolicy columnPolicy, List<ColumnDefinition<T>> nestedColumns) {
        super("object");
        this.columnPolicy = Optional.ofNullable(columnPolicy);
        this.nestedColumns = nestedColumns;
    }

    public Optional<ColumnPolicy> columnPolicy() {
        return this.columnPolicy;
    }

    public List<ColumnDefinition<T>> nestedColumns() {
        return this.nestedColumns;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitObjectColumnType(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectColumnType that = (ObjectColumnType)o;
        if (!this.columnPolicy.equals(that.columnPolicy)) {
            return false;
        }
        return this.nestedColumns.equals(that.nestedColumns);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.columnPolicy.hashCode();
        result = 31 * result + this.nestedColumns.hashCode();
        return result;
    }
}

