/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.SelectItem;
import io.crate.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Update
extends Statement {
    private final Relation relation;
    private final List<Assignment<Expression>> assignments;
    private final Optional<Expression> where;
    private final List<SelectItem> returning;

    public Update(Relation relation, List<Assignment<Expression>> assignments, Optional<Expression> where, List<SelectItem> returning) {
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.assignments = assignments;
        this.where = where;
        this.returning = returning;
    }

    public Relation relation() {
        return this.relation;
    }

    public List<Assignment<Expression>> assignments() {
        return this.assignments;
    }

    public Optional<Expression> whereClause() {
        return this.where;
    }

    public List<SelectItem> returningClause() {
        return this.returning;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Update update = (Update)o;
        return Objects.equals(this.relation, update.relation) && Objects.equals(this.assignments, update.assignments) && Objects.equals(this.where, update.where) && Objects.equals(this.returning, update.returning);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relation, this.assignments, this.where, this.returning);
    }

    @Override
    public String toString() {
        return "Update{relation=" + String.valueOf(this.relation) + ", assignments=" + String.valueOf(this.assignments) + ", where=" + String.valueOf(this.where) + ", returning=" + String.valueOf(this.returning) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUpdate(this, context);
    }
}

