/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.s3.common;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import io.crate.common.annotations.NotThreadSafe;
import io.crate.copy.s3.common.S3URI;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@NotThreadSafe
public class S3ClientHelper {
    private static final Protocol DEFAULT_PROTOCOL = Protocol.HTTPS;
    private static final ClientConfiguration CLIENT_CONFIGURATION = new ClientConfiguration().withProtocol(DEFAULT_PROTOCOL);
    private final Map<Record, AmazonS3> clientMap = new HashMap<Record, AmazonS3>(1);

    @VisibleForTesting
    protected AmazonS3 initClient(@Nullable String accessKey, @Nullable String secretKey, @Nullable String endPoint, String protocolSetting) throws IOException {
        assert (protocolSetting != null) : "protocol setting should not be null";
        AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)(accessKey == null || secretKey == null ? new AnonymousAWSCredentials() : new BasicAWSCredentials(accessKey, secretKey))))).withForceGlobalBucketAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(CLIENT_CONFIGURATION)).withPathStyleAccessEnabled(Boolean.valueOf(true));
        if (endPoint != null) {
            amazonS3ClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(protocolSetting + "://" + endPoint, null));
        } else {
            amazonS3ClientBuilder.withRegion(Regions.DEFAULT_REGION);
        }
        return (AmazonS3)amazonS3ClientBuilder.build();
    }

    public AmazonS3 client(S3URI uri) throws IOException {
        return this.client(uri, DEFAULT_PROTOCOL.toString());
    }

    public AmazonS3 client(S3URI uri, String protocolSetting) throws IOException {
        if (protocolSetting == null) {
            protocolSetting = DEFAULT_PROTOCOL.toString();
        }
        return this.client(uri.accessKey(), uri.secretKey(), uri.endpoint(), protocolSetting);
    }

    private AmazonS3 client(@Nullable String accessKey, @Nullable String secretKey, @Nullable String endPoint, String protocolSetting) throws IOException {
        ClientKey clientKey = new ClientKey(accessKey, secretKey, endPoint, protocolSetting);
        AmazonS3 client = this.clientMap.get(clientKey);
        if (client == null) {
            client = this.initClient(accessKey, secretKey, endPoint, protocolSetting);
            this.clientMap.put(clientKey, client);
        }
        return client;
    }

    static {
        CLIENT_CONFIGURATION.setRetryPolicy(PredefinedRetryPolicies.getDefaultRetryPolicyWithCustomMaxRetries((int)5));
        CLIENT_CONFIGURATION.setUseTcpKeepAlive(true);
    }

    private record ClientKey(String accessKey, String secretKey, String endpoint, String protocol) {
    }
}

