/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContentGenerator;
import org.elasticsearch.common.xcontent.json.JsonXContentParser;
import org.jetbrains.annotations.Nullable;

public class JsonXContent
implements XContent {
    private static final JsonFactory JSON_FACTORY = ((JsonFactoryBuilder)((JsonFactoryBuilder)((JsonFactoryBuilder)new JsonFactoryBuilder().configure(JsonWriteFeature.QUOTE_FIELD_NAMES, true).configure(JsonReadFeature.ALLOW_JAVA_COMMENTS, true).configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false)).configure(StreamWriteFeature.AUTO_CLOSE_CONTENT, false)).configure(StreamReadFeature.STRICT_DUPLICATE_DETECTION, XContent.isStrictDuplicateDetectionEnabled())).build();
    public static final JsonXContent JSON_XCONTENT = new JsonXContent();

    public static XContentBuilder builder() throws IOException {
        return XContentBuilder.builder(JSON_XCONTENT);
    }

    private JsonXContent() {
    }

    @Override
    public XContentType type() {
        return XContentType.JSON;
    }

    @Override
    public byte streamSeparator() {
        return 10;
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os, @Nullable String rootValueSeparator) throws IOException {
        JsonGenerator generator = JSON_FACTORY.createGenerator(os, JsonEncoding.UTF8);
        if (rootValueSeparator != null) {
            generator.setRootValueSeparator((SerializableString)new SerializedString(rootValueSeparator));
        }
        return new JsonXContentGenerator(generator, os);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, JSON_FACTORY.createParser((Reader)new StringReader(content)));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, JSON_FACTORY.createParser(is));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, JSON_FACTORY.createParser(data));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, JSON_FACTORY.createParser(data, offset, length));
    }
}

