/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContentParser;

public class JsonXContentGenerator
implements XContentGenerator {
    protected final JsonGenerator generator;
    private final GeneratorBase base;
    private final OutputStream os;
    private boolean writeLineFeedAtEnd;
    private static final SerializedString LF = new SerializedString("\n");
    private static final DefaultPrettyPrinter.Indenter INDENTER = new DefaultIndenter("  ", LF.getValue());
    private boolean prettyPrint = false;

    public JsonXContentGenerator(JsonGenerator jsonGenerator, OutputStream os) {
        JsonGenerator generator;
        this.os = os;
        this.base = jsonGenerator instanceof GeneratorBase ? (GeneratorBase)jsonGenerator : null;
        this.generator = generator = jsonGenerator;
    }

    @Override
    public XContentType contentType() {
        return XContentType.JSON;
    }

    @Override
    public final void usePrettyPrint() {
        this.generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter(INDENTER).withArrayIndenter(INDENTER));
        this.prettyPrint = true;
    }

    @Override
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public void usePrintLineFeedAtEnd() {
        this.writeLineFeedAtEnd = true;
    }

    private JsonGenerator getLowLevelGenerator() {
        return this.generator;
    }

    @Override
    public void writeStartObject() throws IOException {
        this.generator.writeStartObject();
    }

    @Override
    public void writeEndObject() throws IOException {
        this.generator.writeEndObject();
    }

    @Override
    public void writeStartArray() throws IOException {
        this.generator.writeStartArray();
    }

    @Override
    public void writeEndArray() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void writeNull() throws IOException {
        this.generator.writeNull();
    }

    @Override
    public void writeNullField(String name) throws IOException {
        this.generator.writeNullField(name);
    }

    @Override
    public void writeBooleanField(String name, boolean value) throws IOException {
        this.generator.writeBooleanField(name, value);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.generator.writeBoolean(value);
    }

    @Override
    public void writeNumberField(String name, double value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    @Override
    public void writeNumber(double value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String name, float value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    @Override
    public void writeNumber(float value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String name, int value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    @Override
    public void writeNumberField(String name, BigInteger value) throws IOException {
        this.generator.writeFieldName(name);
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String name, BigDecimal value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    @Override
    public void writeNumber(int value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumberField(String name, long value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    @Override
    public void writeNumber(long value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumber(short value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumber(BigInteger value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeNumber(BigDecimal value) throws IOException {
        this.generator.writeNumber(value);
    }

    @Override
    public void writeStringField(String name, String value) throws IOException {
        this.generator.writeStringField(name, value);
    }

    @Override
    public void writeString(String value) throws IOException {
        this.generator.writeString(value);
    }

    @Override
    public void writeString(char[] value, int offset, int len) throws IOException {
        this.generator.writeString(value, offset, len);
    }

    @Override
    public void writeUTF8String(byte[] value, int offset, int length) throws IOException {
        this.generator.writeUTF8String(value, offset, length);
    }

    @Override
    public void writeBinaryField(String name, byte[] value) throws IOException {
        this.generator.writeBinaryField(name, value);
    }

    @Override
    public void writeBinary(byte[] value) throws IOException {
        this.generator.writeBinary(value);
    }

    @Override
    public void writeBinary(byte[] value, int offset, int len) throws IOException {
        this.generator.writeBinary(value, offset, len);
    }

    public void writeEndRaw() {
        assert (this.base != null) : "JsonGenerator should be of instance GeneratorBase but was: " + String.valueOf(this.generator.getClass());
        if (this.base != null) {
            JsonStreamContext context = this.base.getOutputContext();
            assert (context instanceof JsonWriteContext) : "Expected an instance of JsonWriteContext but was: " + String.valueOf(context.getClass());
            ((JsonWriteContext)context).writeValue();
        }
    }

    @Override
    public void writeRawValue(InputStream stream, XContentType xContentType) throws IOException {
        if (!this.mayWriteRawData(xContentType)) {
            this.copyRawValue(stream, xContentType.xContent());
        } else {
            if (this.generator.getOutputContext().getCurrentName() != null) {
                this.generator.writeRaw(':');
            }
            this.flush();
            stream.transferTo(this.os);
            this.writeEndRaw();
        }
    }

    private boolean mayWriteRawData(XContentType contentType) {
        return this.supportsRawWrites() && contentType == this.contentType() && !this.prettyPrint;
    }

    protected boolean supportsRawWrites() {
        return true;
    }

    protected void copyRawValue(InputStream stream, XContent xContent) throws IOException {
        try (XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, stream);){
            this.copyCurrentStructure(parser);
        }
    }

    @Override
    public void copyCurrentStructure(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser instanceof JsonXContentParser) {
            this.generator.copyCurrentStructure(((JsonXContentParser)parser).parser);
        } else {
            JsonXContentGenerator.copyCurrentStructure(this, parser);
        }
    }

    private static void copyCurrentStructure(XContentGenerator destination, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.FIELD_NAME) {
            destination.writeFieldName(parser.currentName());
            token = parser.nextToken();
        }
        switch (token) {
            case START_ARRAY: {
                destination.writeStartArray();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    JsonXContentGenerator.copyCurrentStructure(destination, parser);
                }
                destination.writeEndArray();
                break;
            }
            case START_OBJECT: {
                destination.writeStartObject();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    JsonXContentGenerator.copyCurrentStructure(destination, parser);
                }
                destination.writeEndObject();
                break;
            }
            default: {
                destination.copyCurrentEvent(parser);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.generator.isClosed()) {
            return;
        }
        JsonStreamContext context = this.generator.getOutputContext();
        if (context != null && !context.inRoot()) {
            throw new IOException("Unclosed object or array found");
        }
        if (this.writeLineFeedAtEnd) {
            this.flush();
            this.getLowLevelGenerator().writeRaw((SerializableString)LF);
        }
        this.generator.close();
    }

    @Override
    public boolean isClosed() {
        return this.generator.isClosed();
    }

    @Override
    public void configure(JsonGenerator.Feature f, boolean state) {
        this.generator.configure(f, state);
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature f) {
        return this.generator.isEnabled(f);
    }
}

