/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.util.json.Jackson;
import io.crate.analyze.repositories.TypeSettings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.S3RepositorySettings;
import org.elasticsearch.repositories.s3.S3Service;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    protected final S3Service service = new S3Service();

    public List<Setting<?>> getSettings() {
        return List.of(S3RepositorySettings.ACCESS_KEY_SETTING, S3RepositorySettings.SECRET_KEY_SETTING);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, final NamedWriteableRegistry namedWriteableRegistry, final NamedXContentRegistry registry, final ClusterService clusterService, final RecoverySettings recoverySettings) {
        return Collections.singletonMap("s3", new Repository.Factory(){
            final /* synthetic */ S3RepositoryPlugin this$0;
            {
                this.this$0 = this$0;
            }

            public TypeSettings settings() {
                return new TypeSettings(List.of(), S3Repository.optionalSettings());
            }

            public Repository create(RepositoryMetadata metadata) throws Exception {
                return new S3Repository(metadata, namedWriteableRegistry, registry, this.this$0.service, clusterService, recoverySettings);
            }
        });
    }

    public void close() {
        this.service.close();
    }

    static {
        try {
            Jackson.jsonNodeOf((String)"{}");
            Class.forName("com.amazonaws.ClientConfiguration");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

