/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.common.concurrent.Killable;
import io.crate.data.MappedForwardingBatchIterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public interface BatchIterator<T>
extends Killable {
    public static final IllegalStateException CLOSED;

    public T currentElement();

    public void moveToStart();

    public boolean moveNext();

    public void close();

    public CompletionStage<?> loadNextBatch() throws Exception;

    public boolean allLoaded();

    public boolean hasLazyResultSet();

    default public void move(int steps, Consumer<T> onNext, Consumer<Throwable> onFinish) {
        if (!2.$assertionsDisabled && steps < 0) {
            throw new AssertionError((Object)"steps must be positive");
        }
        try {
            for (int i = 0; i < steps; ++i) {
                if (this.moveNext()) {
                    onNext.accept(this.currentElement());
                    continue;
                }
                if (this.allLoaded()) {
                    onFinish.accept(null);
                    return;
                }
                CompletableFuture<?> nextBatch = this.loadNextBatch().toCompletableFuture();
                if (nextBatch.isDone()) {
                    if (nextBatch.isCompletedExceptionally()) {
                        nextBatch.join();
                    }
                    --i;
                    continue;
                }
                int remainingSteps = steps - i;
                nextBatch.whenComplete((res, err) -> {
                    if (err == null) {
                        this.move(remainingSteps, onNext, onFinish);
                    } else {
                        onFinish.accept((Throwable)err);
                    }
                });
                return;
            }
            onFinish.accept(null);
        }
        catch (Throwable ex) {
            onFinish.accept(ex);
        }
    }

    default public <O> BatchIterator<O> map(final Function<? super T, ? extends O> mapper) {
        final BatchIterator source = this;
        return new MappedForwardingBatchIterator<T, O>(this){

            @Override
            public O currentElement() {
                return mapper.apply(source.currentElement());
            }

            @Override
            protected BatchIterator<T> delegate() {
                return source;
            }
        };
    }

    default public <A, R> CompletableFuture<R> collect(Collector<T, A, R> collector, boolean close) {
        BiConsumer accumulator = collector.accumulator();
        Function finisher = collector.finisher();
        Object state = collector.supplier().get();
        CompletableFuture result = new CompletableFuture();
        this.move(Integer.MAX_VALUE, row -> accumulator.accept(state, row), err -> {
            if (close) {
                this.close();
            }
            if (err == null) {
                result.complete(finisher.apply(state));
            } else {
                result.completeExceptionally((Throwable)err);
            }
        });
        return result;
    }

    default public <A, R> CompletableFuture<R> collect(Collector<T, A, R> collector) {
        return this.collect(collector, true);
    }

    default public <R> CompletableFuture<List<T>> toList() {
        return this.collect(Collectors.toList());
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        CLOSED = new IllegalStateException("BatchIterator is closed");
    }
}

