/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import io.crate.data.MappedForwardingBatchIterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class BatchIterators {
    public static <T, A, R> CompletableFuture<R> collect(BatchIterator<T> it, A state, Collector<T, A, R> collector, CompletableFuture<R> resultFuture) {
        BiConsumer accumulator = collector.accumulator();
        Function finisher = collector.finisher();
        it.move(Integer.MAX_VALUE, row -> accumulator.accept(state, row), err -> {
            it.close();
            if (err == null) {
                resultFuture.complete(finisher.apply(state));
            } else {
                resultFuture.completeExceptionally((Throwable)err);
            }
        });
        return resultFuture;
    }

    public static <T, A> BatchIterator<A> chunks(final BatchIterator<T> bi, final int size, final Supplier<A> supplier, final BiConsumer<A, T> accumulator, final Predicate<? super A> stateLimiter) {
        return new MappedForwardingBatchIterator<T, A>(){
            private A element = null;
            private A state = supplier.get();
            private int idx = 0;

            @Override
            protected BatchIterator<T> delegate() {
                return bi;
            }

            @Override
            public boolean moveNext() {
                boolean stateLimitReached = false;
                while (this.idx < size && !stateLimitReached && bi.moveNext()) {
                    accumulator.accept(this.state, bi.currentElement());
                    stateLimitReached = stateLimiter.test(this.state);
                    ++this.idx;
                }
                if (this.idx == size || stateLimitReached || this.idx > 0 && bi.allLoaded()) {
                    this.element = this.state;
                    this.state = supplier.get();
                    this.idx = 0;
                    return true;
                }
                this.element = null;
                return false;
            }

            @Override
            public A currentElement() {
                return this.element;
            }
        };
    }
}

