/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data.join;

import io.crate.data.BatchIterator;
import io.crate.data.join.ElementCombiner;
import io.crate.data.join.JoinBatchIterator;
import java.util.BitSet;
import java.util.function.Predicate;

public class FullOuterJoinNLBatchIterator<L, R, C>
extends JoinBatchIterator<L, R, C> {
    private final BitSet matchedRows = new BitSet();
    private final Predicate<C> joinCondition;
    private boolean postNL = false;
    private boolean hadMatch = false;
    private int position = -1;

    public FullOuterJoinNLBatchIterator(BatchIterator<L> left, BatchIterator<R> right, ElementCombiner<L, R, C> combiner, Predicate<C> joinCondition) {
        super(left, right, combiner);
        this.joinCondition = joinCondition;
    }

    @Override
    public void moveToStart() {
        this.postNL = false;
        this.hadMatch = false;
        this.position = -1;
        this.activeIt = this.left;
        super.moveToStart();
    }

    @Override
    public boolean moveNext() {
        if (this.postNL) {
            return this.moveRightPostNL();
        }
        while (this.activeIt != this.left) {
            Boolean x = this.tryAdvanceRight();
            if (x != null) {
                return x;
            }
            this.activeIt = this.left;
        }
        return this.moveLeft();
    }

    private boolean moveLeft() {
        while (this.tryMoveLeft()) {
            this.activeIt = this.right;
            Boolean x = this.tryAdvanceRight();
            if (x == null) continue;
            return x;
        }
        this.activeIt = this.left;
        this.postNL = this.left.allLoaded();
        if (this.postNL) {
            this.position = -1;
            this.activeIt = this.right;
            this.combiner.nullLeft();
            return this.moveRightPostNL();
        }
        return false;
    }

    private Boolean tryAdvanceRight() {
        while (this.tryMoveRight()) {
            ++this.position;
            if (!this.joinCondition.test(this.combiner.currentElement())) continue;
            this.hadMatch = true;
            this.matchedRows.set(this.position);
            return true;
        }
        if (!this.right.allLoaded()) {
            return false;
        }
        this.position = -1;
        this.right.moveToStart();
        if (!this.hadMatch) {
            this.combiner.nullRight();
            this.activeIt = this.left;
            return true;
        }
        this.hadMatch = false;
        return null;
    }

    private boolean moveRightPostNL() {
        while (this.tryMoveRight()) {
            ++this.position;
            if (this.matchedRows.get(this.position)) continue;
            return true;
        }
        return false;
    }
}

