/*
 * Decompiled with CFR 0.152.
 */
package io.crate.beans;

import io.crate.beans.QueryStatsMBean;
import io.crate.common.Suppliers;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.metadata.sys.MetricsView;
import io.crate.planner.Plan;
import io.crate.planner.operators.StatementClassifier;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class QueryStats
implements QueryStatsMBean {
    private static final Set<Plan.StatementType> CLASSIFIED_STATEMENT_TYPES = Set.of(Plan.StatementType.SELECT, Plan.StatementType.INSERT, Plan.StatementType.UPDATE, Plan.StatementType.DELETE, Plan.StatementType.MANAGEMENT, Plan.StatementType.COPY, Plan.StatementType.DDL);
    public static final String NAME = "io.crate.monitoring:type=QueryStats";
    private static final Metric DEFAULT_METRIC = new Metric(0L, 0L, 0L){

        @Override
        void inc(long duration, long totalCount, long failedCount) {
            throw new AssertionError((Object)"inc must not be called on default metric - it's immutable");
        }
    };
    private final Supplier<Map<Plan.StatementType, Metric>> metricByStmtType = Suppliers.memoizeWithExpiration(() -> QueryStats.createMetricsMap(jobsLogs.metrics()), (long)1L, (TimeUnit)TimeUnit.SECONDS);

    public QueryStats(JobsLogs jobsLogs) {
    }

    static Map<Plan.StatementType, Metric> createMetricsMap(Iterable<MetricsView> metrics) {
        EnumMap<Plan.StatementType, Metric> metricsByStmtType = new EnumMap<Plan.StatementType, Metric>(Plan.StatementType.class);
        for (MetricsView classifiedMetrics : metrics) {
            long sumOfDurations = classifiedMetrics.sumOfDurations();
            long failedCount = classifiedMetrics.failedCount();
            metricsByStmtType.compute(QueryStats.classificationType(classifiedMetrics.classification()), (key, oldMetric) -> {
                if (oldMetric == null) {
                    return new Metric(sumOfDurations, classifiedMetrics.totalCount(), failedCount);
                }
                oldMetric.inc(sumOfDurations, classifiedMetrics.totalCount(), failedCount);
                return oldMetric;
            });
        }
        return metricsByStmtType;
    }

    private static Plan.StatementType classificationType(StatementClassifier.Classification classification) {
        if (classification == null || !CLASSIFIED_STATEMENT_TYPES.contains(classification.type())) {
            return Plan.StatementType.UNDEFINED;
        }
        return classification.type();
    }

    @Override
    public long getSelectQueryTotalCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.SELECT, DEFAULT_METRIC).totalCount();
    }

    @Override
    public long getInsertQueryTotalCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.INSERT, DEFAULT_METRIC).totalCount();
    }

    @Override
    public long getUpdateQueryTotalCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.UPDATE, DEFAULT_METRIC).totalCount();
    }

    @Override
    public long getDeleteQueryTotalCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.DELETE, DEFAULT_METRIC).totalCount();
    }

    @Override
    public long getManagementQueryTotalCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.MANAGEMENT, DEFAULT_METRIC).totalCount();
    }

    @Override
    public long getDDLQueryTotalCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.DDL, DEFAULT_METRIC).totalCount();
    }

    @Override
    public long getCopyQueryTotalCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.COPY, DEFAULT_METRIC).totalCount();
    }

    @Override
    public long getUndefinedQueryTotalCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.UNDEFINED, DEFAULT_METRIC).totalCount();
    }

    @Override
    public long getSelectQuerySumOfDurations() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.SELECT, DEFAULT_METRIC).sumOfDurations();
    }

    @Override
    public long getInsertQuerySumOfDurations() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.INSERT, DEFAULT_METRIC).sumOfDurations();
    }

    @Override
    public long getUpdateQuerySumOfDurations() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.UPDATE, DEFAULT_METRIC).sumOfDurations();
    }

    @Override
    public long getDeleteQuerySumOfDurations() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.DELETE, DEFAULT_METRIC).sumOfDurations();
    }

    @Override
    public long getManagementQuerySumOfDurations() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.MANAGEMENT, DEFAULT_METRIC).sumOfDurations();
    }

    @Override
    public long getDDLQuerySumOfDurations() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.DDL, DEFAULT_METRIC).sumOfDurations();
    }

    @Override
    public long getCopyQuerySumOfDurations() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.COPY, DEFAULT_METRIC).sumOfDurations();
    }

    @Override
    public long getUndefinedQuerySumOfDurations() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.UNDEFINED, DEFAULT_METRIC).sumOfDurations();
    }

    @Override
    public long getSelectQueryFailedCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.SELECT, DEFAULT_METRIC).failedCount();
    }

    @Override
    public long getInsertQueryFailedCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.INSERT, DEFAULT_METRIC).failedCount();
    }

    @Override
    public long getUpdateQueryFailedCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.UPDATE, DEFAULT_METRIC).failedCount();
    }

    @Override
    public long getDeleteQueryFailedCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.DELETE, DEFAULT_METRIC).failedCount();
    }

    @Override
    public long getManagementQueryFailedCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.MANAGEMENT, DEFAULT_METRIC).failedCount();
    }

    @Override
    public long getDDLQueryFailedCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.DDL, DEFAULT_METRIC).failedCount();
    }

    @Override
    public long getCopyQueryFailedCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.COPY, DEFAULT_METRIC).failedCount();
    }

    @Override
    public long getUndefinedQueryFailedCount() {
        return this.metricByStmtType.get().getOrDefault(Plan.StatementType.UNDEFINED, DEFAULT_METRIC).failedCount();
    }

    static class Metric {
        private long failedCount;
        private long totalCount;
        private long sumOfDurations;

        Metric(long sumOfDurations, long totalCount, long failedCount) {
            this.sumOfDurations = sumOfDurations;
            this.totalCount = totalCount;
            this.failedCount = failedCount;
        }

        void inc(long duration, long totalCount, long failedCount) {
            this.sumOfDurations += duration;
            this.totalCount += totalCount;
            this.failedCount += failedCount;
        }

        long totalCount() {
            return this.totalCount;
        }

        long sumOfDurations() {
            return this.sumOfDurations;
        }

        long failedCount() {
            return this.failedCount;
        }
    }
}

