/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal;

import java.time.Instant;
import lombok.Generated;

public class Metadata {
    public final EntryMode mode;
    public final long contentLength;
    public final String contentDisposition;
    public final String contentMd5;
    public final String contentType;
    public final String cacheControl;
    public final String etag;
    public final Instant lastModified;
    public final String version;

    public Metadata(int mode, long contentLength, String contentDisposition, String contentMd5, String contentType, String cacheControl, String etag, Instant lastModified, String version) {
        this.mode = EntryMode.of(mode);
        this.contentLength = contentLength;
        this.contentDisposition = contentDisposition;
        this.contentMd5 = contentMd5;
        this.contentType = contentType;
        this.cacheControl = cacheControl;
        this.etag = etag;
        this.lastModified = lastModified;
        this.version = version;
    }

    public boolean isFile() {
        return this.mode == EntryMode.FILE;
    }

    public boolean isDir() {
        return this.mode == EntryMode.DIR;
    }

    @Generated
    public EntryMode getMode() {
        return this.mode;
    }

    @Generated
    public long getContentLength() {
        return this.contentLength;
    }

    @Generated
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    @Generated
    public String getContentMd5() {
        return this.contentMd5;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public String getCacheControl() {
        return this.cacheControl;
    }

    @Generated
    public String getEtag() {
        return this.etag;
    }

    @Generated
    public Instant getLastModified() {
        return this.lastModified;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContentLength() != other.getContentLength()) {
            return false;
        }
        EntryMode this$mode = this.getMode();
        EntryMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        String this$contentDisposition = this.getContentDisposition();
        String other$contentDisposition = other.getContentDisposition();
        if (this$contentDisposition == null ? other$contentDisposition != null : !this$contentDisposition.equals(other$contentDisposition)) {
            return false;
        }
        String this$contentMd5 = this.getContentMd5();
        String other$contentMd5 = other.getContentMd5();
        if (this$contentMd5 == null ? other$contentMd5 != null : !this$contentMd5.equals(other$contentMd5)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$cacheControl = this.getCacheControl();
        String other$cacheControl = other.getCacheControl();
        if (this$cacheControl == null ? other$cacheControl != null : !this$cacheControl.equals(other$cacheControl)) {
            return false;
        }
        String this$etag = this.getEtag();
        String other$etag = other.getEtag();
        if (this$etag == null ? other$etag != null : !this$etag.equals(other$etag)) {
            return false;
        }
        Instant this$lastModified = this.getLastModified();
        Instant other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Metadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $contentLength = this.getContentLength();
        result = result * 59 + (int)($contentLength >>> 32 ^ $contentLength);
        EntryMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        String $contentDisposition = this.getContentDisposition();
        result = result * 59 + ($contentDisposition == null ? 43 : $contentDisposition.hashCode());
        String $contentMd5 = this.getContentMd5();
        result = result * 59 + ($contentMd5 == null ? 43 : $contentMd5.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $cacheControl = this.getCacheControl();
        result = result * 59 + ($cacheControl == null ? 43 : $cacheControl.hashCode());
        String $etag = this.getEtag();
        result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
        Instant $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Metadata(mode=" + (Object)((Object)this.getMode()) + ", contentLength=" + this.getContentLength() + ", contentDisposition=" + this.getContentDisposition() + ", contentMd5=" + this.getContentMd5() + ", contentType=" + this.getContentType() + ", cacheControl=" + this.getCacheControl() + ", etag=" + this.getEtag() + ", lastModified=" + this.getLastModified() + ", version=" + this.getVersion() + ")";
    }

    public static enum EntryMode {
        FILE,
        DIR,
        UNKNOWN;


        public static EntryMode of(int mode) {
            switch (mode) {
                case 0: {
                    return FILE;
                }
                case 1: {
                    return DIR;
                }
            }
            return UNKNOWN;
        }
    }
}

