/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.opendal.NativeObject;
import org.apache.opendal.Operator;

public class OperatorOutputStream
extends OutputStream {
    private static final int DEFAULT_MAX_BYTES = 16384;
    private final Writer writer;
    private final byte[] bytes;
    private final int maxBytes;
    private int offset = 0;

    public OperatorOutputStream(Operator operator, String path) {
        this(operator, path, 16384);
    }

    public OperatorOutputStream(Operator operator, String path, int maxBytes) {
        long op = operator.nativeHandle;
        this.writer = new Writer(OperatorOutputStream.constructWriter(op, path));
        this.maxBytes = maxBytes;
        this.bytes = new byte[maxBytes];
    }

    @Override
    public void write(int b) throws IOException {
        this.bytes[this.offset++] = (byte)b;
        if (this.offset >= this.maxBytes) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.offset > this.maxBytes) {
            throw new IOException("INTERNAL ERROR: " + this.offset + " > " + this.maxBytes);
        }
        if (this.offset < this.maxBytes) {
            byte[] bytes = Arrays.copyOf(this.bytes, this.offset);
            OperatorOutputStream.writeBytes(this.writer.nativeHandle, bytes);
        } else {
            OperatorOutputStream.writeBytes(this.writer.nativeHandle, this.bytes);
        }
        this.offset = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    private static native long constructWriter(long var0, String var2);

    private static native long disposeWriter(long var0);

    private static native byte[] writeBytes(long var0, byte[] var2);

    private static class Writer
    extends NativeObject {
        private Writer(long nativeHandle) {
            super(nativeHandle);
        }

        @Override
        protected void disposeInternal(long handle) {
            OperatorOutputStream.disposeWriter(handle);
        }
    }
}

