/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.azure;

import io.crate.copy.azure.AzureFileInputFactory;
import io.crate.copy.azure.AzureFileOutputFactory;
import io.crate.copy.azure.SharedAsyncExecutor;
import io.crate.execution.engine.collect.files.FileInputFactory;
import io.crate.execution.engine.export.FileOutputFactory;
import io.crate.plugin.CopyPlugin;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.threadpool.ThreadPool;

public class AzureCopyPlugin
extends Plugin
implements CopyPlugin {
    public static final String OPEN_DAL_SCHEME = "azblob";
    public static final String USER_FACING_SCHEME = "az";
    private final SharedAsyncExecutor sharedAsyncExecutor;

    @Inject
    public AzureCopyPlugin(Settings settings) {
        this.sharedAsyncExecutor = new SharedAsyncExecutor(settings);
    }

    public Map<String, FileInputFactory> getFileInputFactories() {
        return Map.of(USER_FACING_SCHEME, new AzureFileInputFactory(this.sharedAsyncExecutor));
    }

    public Map<String, FileOutputFactory> getFileOutputFactories() {
        return Map.of(USER_FACING_SCHEME, new AzureFileOutputFactory(this.sharedAsyncExecutor));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.singletonList(this.sharedAsyncExecutor);
    }
}

