/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common;

import java.util.Arrays;
import java.util.Locale;

public class Octal {
    private Octal() {
    }

    public static String encode(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length);
        for (byte b : data) {
            if (b == 92) {
                sb.append("\\\\");
                continue;
            }
            if (b < 32 || b > 126) {
                sb.append('\\');
                sb.append(b >> 6 & 3);
                sb.append(b >> 3 & 7);
                sb.append(b & 7);
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    public static byte[] decode(String octalData) {
        byte[] decodedBytes = new byte[octalData.length()];
        char[] encodedChars = octalData.toCharArray();
        int decIndex = 0;
        for (int encIndex = 0; encIndex < encodedChars.length; ++encIndex) {
            char c = encodedChars[encIndex];
            if (c == '\\') {
                if (encIndex + 1 >= encodedChars.length) {
                    Octal.throwOnTruncatedOctalSequence(encIndex);
                }
                if (encodedChars[encIndex + 1] == '\\') {
                    decodedBytes[decIndex++] = 92;
                    ++encIndex;
                    continue;
                }
                if (encIndex + 3 >= encodedChars.length) {
                    Octal.throwOnTruncatedOctalSequence(encIndex);
                }
                decodedBytes[decIndex++] = (byte)(64 * Octal.ensureOctalCharacter(encodedChars, encIndex + 1) + 8 * Octal.ensureOctalCharacter(encodedChars, encIndex + 2) + Octal.ensureOctalCharacter(encodedChars, encIndex + 3));
                encIndex += 3;
                continue;
            }
            decodedBytes[decIndex++] = (byte)c;
        }
        if (decIndex == decodedBytes.length) {
            return decodedBytes;
        }
        return Arrays.copyOf(decodedBytes, decIndex);
    }

    private static int ensureOctalCharacter(char[] chars, int index) {
        int o = Character.digit(chars[index], 8);
        if (o > 7 || o < 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Illegal octal character %s at index %d", Character.valueOf(chars[index]), index));
        }
        return o;
    }

    private static void throwOnTruncatedOctalSequence(int index) {
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid escape sequence at index %d: expected 1 or 3 more characters but the end of the string got reached", index));
    }
}

