/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public final class MapBuilder<K, V> {
    private final Map<K, V> map;

    public static <K, V> MapBuilder<K, V> newMapBuilder() {
        return new MapBuilder<K, V>();
    }

    public static <K, V> MapBuilder<K, V> newMapBuilder(Map<K, V> map) {
        return new MapBuilder<K, V>(new HashMap<K, V>(map));
    }

    public static <K, V> MapBuilder<K, V> newLinkedHashMapBuilder() {
        return new MapBuilder(new LinkedHashMap());
    }

    public static <K extends Comparable<?>, V> MapBuilder<K, V> treeMapBuilder() {
        return new MapBuilder(new TreeMap());
    }

    private MapBuilder() {
        this.map = new HashMap();
    }

    private MapBuilder(Map<K, V> map) {
        this.map = map;
    }

    public MapBuilder<K, V> put(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public Map<K, V> map() {
        return this.map;
    }

    public Map<K, V> immutableMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public void putAll(Map<K, V> value) {
        this.map.putAll(value);
    }
}

