/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import org.graalvm.collections.EconomicSet;

public final class ClassSetContents
implements JsonConvertible {
    private final Kind kind;
    private final CodePointSet codePointSet;
    private final EconomicSet<String> strings;
    private final boolean mayContainStrings;

    private ClassSetContents(Kind kind, CodePointSet codePointSet, EconomicSet<String> strings, boolean mayContainStrings) {
        this.kind = kind;
        this.codePointSet = codePointSet;
        this.strings = strings;
        this.mayContainStrings = mayContainStrings;
    }

    public static ClassSetContents createCharacter(int codePoint) {
        return new ClassSetContents(Kind.Character, CodePointSet.create(codePoint), (EconomicSet<String>)EconomicSet.create(), false);
    }

    public static ClassSetContents createUnicodePropertyOfStrings(CodePointSet codePointSet, EconomicSet<String> strings) {
        return new ClassSetContents(Kind.Class, codePointSet, strings, true);
    }

    public static ClassSetContents createCharacterClass(CodePointSet codePointSet) {
        return new ClassSetContents(Kind.Class, codePointSet, (EconomicSet<String>)EconomicSet.create(), false);
    }

    public static ClassSetContents createClass(CodePointSet codePointSet, EconomicSet<String> strings, boolean mayContainStrings) {
        return new ClassSetContents(Kind.Class, codePointSet, strings, mayContainStrings);
    }

    public static ClassSetContents createStrings(CodePointSet singleCodePoints, EconomicSet<String> strings) {
        return new ClassSetContents(Kind.Strings, singleCodePoints, strings, !strings.isEmpty());
    }

    public static ClassSetContents createRange(int lo, int hi) {
        return new ClassSetContents(Kind.Range, CodePointSet.create(lo, hi), (EconomicSet<String>)EconomicSet.create(), false);
    }

    public static ClassSetContents createPOSIXCollationElement(int codePoint) {
        return new ClassSetContents(Kind.POSIXCollationElement, CodePointSet.create(codePoint), (EconomicSet<String>)EconomicSet.create(), false);
    }

    public static ClassSetContents createPOSIXCollationElement(String string) {
        EconomicSet strings = EconomicSet.create();
        strings.add((Object)string);
        return new ClassSetContents(Kind.POSIXCollationElement, CodePointSet.getEmpty(), (EconomicSet<String>)strings, true);
    }

    public static ClassSetContents createPOSIXCollationEquivalenceClass(int codePoint) {
        return new ClassSetContents(Kind.POSIXCollationEquivalenceClass, CodePointSet.create(codePoint), (EconomicSet<String>)EconomicSet.create(), false);
    }

    public static ClassSetContents createPOSIXCollationEquivalenceClass(String string) {
        EconomicSet strings = EconomicSet.create();
        strings.add((Object)string);
        return new ClassSetContents(Kind.POSIXCollationEquivalenceClass, CodePointSet.getEmpty(), (EconomicSet<String>)strings, true);
    }

    public ClassSetContents unionUnicodePropertyOfStrings(ClassSetContents other) {
        EconomicSet unionStrings = EconomicSet.create();
        unionStrings.addAll(this.strings);
        unionStrings.addAll(other.strings);
        return new ClassSetContents(Kind.Class, this.codePointSet.union(other.codePointSet), (EconomicSet<String>)unionStrings, this.mayContainStrings || other.mayContainStrings);
    }

    public ClassSetContents caseFold(CodePointSetAccumulator tmp) {
        EconomicSet foldedStrings = EconomicSet.create((int)this.strings.size());
        for (String string : this.strings) {
            foldedStrings.add((Object)CaseFoldData.icuSimpleCaseFold(string));
        }
        return new ClassSetContents(this.kind, CaseFoldData.simpleCaseFold(this.codePointSet, tmp), (EconomicSet<String>)foldedStrings, this.mayContainStrings);
    }

    public EconomicSet<String> getStrings() {
        return this.strings;
    }

    public CodePointSet getCodePointSet() {
        return this.codePointSet;
    }

    public boolean isCharacter() {
        return this.kind == Kind.Character;
    }

    public boolean isCharacterClass() {
        return this.kind == Kind.Class;
    }

    public boolean isRange() {
        return this.kind == Kind.Range;
    }

    public boolean isPosixCollationElement() {
        return this.kind == Kind.POSIXCollationElement;
    }

    public boolean isPosixCollationEquivalenceClass() {
        return this.kind == Kind.POSIXCollationEquivalenceClass;
    }

    public boolean isAllowedInRange() {
        return this.kind == Kind.Character || (this.kind == Kind.POSIXCollationElement || this.kind == Kind.POSIXCollationEquivalenceClass) && this.isCodePointSetOnly();
    }

    public int getCodePoint() {
        assert (this.isAllowedInRange());
        return this.codePointSet.getLo(0);
    }

    public boolean isCodePointSetOnly() {
        return this.strings.isEmpty();
    }

    public boolean mayContainStrings() {
        return this.mayContainStrings;
    }

    @Override
    public JsonValue toJson() {
        return null;
    }

    static enum Kind {
        Character,
        Class,
        Strings,
        Range,
        POSIXCollationElement,
        POSIXCollationEquivalenceClass;

    }
}

