/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.parser;

import io.crate.common.collections.Lists;
import io.crate.sql.ExpressionFormatter;
import io.crate.sql.parser.antlr.SqlBaseParser;
import io.crate.sql.parser.antlr.SqlBaseParserBaseVisitor;
import io.crate.sql.tree.AddColumnDefinition;
import io.crate.sql.tree.AliasedRelation;
import io.crate.sql.tree.AllColumns;
import io.crate.sql.tree.AlterClusterRerouteRetryFailed;
import io.crate.sql.tree.AlterPublication;
import io.crate.sql.tree.AlterRoleReset;
import io.crate.sql.tree.AlterRoleSet;
import io.crate.sql.tree.AlterServer;
import io.crate.sql.tree.AlterSubscription;
import io.crate.sql.tree.AlterTable;
import io.crate.sql.tree.AlterTableAddColumn;
import io.crate.sql.tree.AlterTableDropColumn;
import io.crate.sql.tree.AlterTableOpenClose;
import io.crate.sql.tree.AlterTableRenameColumn;
import io.crate.sql.tree.AlterTableRenameTable;
import io.crate.sql.tree.AlterTableReroute;
import io.crate.sql.tree.AnalyzeStatement;
import io.crate.sql.tree.AnalyzerElement;
import io.crate.sql.tree.ArithmeticExpression;
import io.crate.sql.tree.ArrayComparison;
import io.crate.sql.tree.ArrayComparisonExpression;
import io.crate.sql.tree.ArrayLikePredicate;
import io.crate.sql.tree.ArrayLiteral;
import io.crate.sql.tree.ArraySliceExpression;
import io.crate.sql.tree.ArraySubQueryExpression;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.BeginStatement;
import io.crate.sql.tree.BetweenPredicate;
import io.crate.sql.tree.BitString;
import io.crate.sql.tree.BitwiseExpression;
import io.crate.sql.tree.BooleanLiteral;
import io.crate.sql.tree.CascadeMode;
import io.crate.sql.tree.Cast;
import io.crate.sql.tree.CharFilters;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.Close;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.CollectionColumnType;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ColumnStorageDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.CommitStatement;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.CopyTo;
import io.crate.sql.tree.CreateAnalyzer;
import io.crate.sql.tree.CreateBlobTable;
import io.crate.sql.tree.CreateForeignTable;
import io.crate.sql.tree.CreateFunction;
import io.crate.sql.tree.CreatePublication;
import io.crate.sql.tree.CreateRepository;
import io.crate.sql.tree.CreateRole;
import io.crate.sql.tree.CreateServer;
import io.crate.sql.tree.CreateSnapshot;
import io.crate.sql.tree.CreateSubscription;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.CreateTableAs;
import io.crate.sql.tree.CreateUserMapping;
import io.crate.sql.tree.CreateView;
import io.crate.sql.tree.CurrentTime;
import io.crate.sql.tree.DeallocateStatement;
import io.crate.sql.tree.Declare;
import io.crate.sql.tree.DecommissionNodeStatement;
import io.crate.sql.tree.DefaultConstraint;
import io.crate.sql.tree.Delete;
import io.crate.sql.tree.DenyPrivilege;
import io.crate.sql.tree.DiscardStatement;
import io.crate.sql.tree.DoubleLiteral;
import io.crate.sql.tree.DropAnalyzer;
import io.crate.sql.tree.DropBlobTable;
import io.crate.sql.tree.DropCheckConstraint;
import io.crate.sql.tree.DropColumnDefinition;
import io.crate.sql.tree.DropForeignTable;
import io.crate.sql.tree.DropFunction;
import io.crate.sql.tree.DropPublication;
import io.crate.sql.tree.DropRepository;
import io.crate.sql.tree.DropRole;
import io.crate.sql.tree.DropServer;
import io.crate.sql.tree.DropSnapshot;
import io.crate.sql.tree.DropSubscription;
import io.crate.sql.tree.DropTable;
import io.crate.sql.tree.DropUserMapping;
import io.crate.sql.tree.DropView;
import io.crate.sql.tree.EscapedCharStringLiteral;
import io.crate.sql.tree.Except;
import io.crate.sql.tree.ExistsPredicate;
import io.crate.sql.tree.Explain;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Extract;
import io.crate.sql.tree.Fetch;
import io.crate.sql.tree.FrameBound;
import io.crate.sql.tree.FunctionArgument;
import io.crate.sql.tree.FunctionCall;
import io.crate.sql.tree.GCDanglingArtifacts;
import io.crate.sql.tree.GeneratedExpressionConstraint;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.GenericProperty;
import io.crate.sql.tree.GrantPrivilege;
import io.crate.sql.tree.GroupBy;
import io.crate.sql.tree.IfExpression;
import io.crate.sql.tree.InListExpression;
import io.crate.sql.tree.InPredicate;
import io.crate.sql.tree.IndexColumnConstraint;
import io.crate.sql.tree.IndexDefinition;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.Intersect;
import io.crate.sql.tree.IntervalLiteral;
import io.crate.sql.tree.IsNotNullPredicate;
import io.crate.sql.tree.IsNullPredicate;
import io.crate.sql.tree.Join;
import io.crate.sql.tree.JoinCriteria;
import io.crate.sql.tree.JoinOn;
import io.crate.sql.tree.JoinType;
import io.crate.sql.tree.JoinUsing;
import io.crate.sql.tree.KillStatement;
import io.crate.sql.tree.LikePredicate;
import io.crate.sql.tree.Literal;
import io.crate.sql.tree.LogicalBinaryExpression;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.MatchPredicate;
import io.crate.sql.tree.MatchPredicateColumnIdent;
import io.crate.sql.tree.MultiStatement;
import io.crate.sql.tree.NamedProperties;
import io.crate.sql.tree.NaturalJoin;
import io.crate.sql.tree.NegativeExpression;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.NotExpression;
import io.crate.sql.tree.NotNullColumnConstraint;
import io.crate.sql.tree.NullColumnConstraint;
import io.crate.sql.tree.NullLiteral;
import io.crate.sql.tree.NumericLiteral;
import io.crate.sql.tree.ObjectColumnType;
import io.crate.sql.tree.ObjectLiteral;
import io.crate.sql.tree.OptimizeStatement;
import io.crate.sql.tree.ParameterExpression;
import io.crate.sql.tree.PartitionedBy;
import io.crate.sql.tree.PrimaryKeyColumnConstraint;
import io.crate.sql.tree.PrimaryKeyConstraint;
import io.crate.sql.tree.PromoteReplica;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.QueryBody;
import io.crate.sql.tree.QuerySpecification;
import io.crate.sql.tree.RecordSubscript;
import io.crate.sql.tree.RefreshStatement;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.RerouteAllocateReplicaShard;
import io.crate.sql.tree.RerouteCancelShard;
import io.crate.sql.tree.RerouteMoveShard;
import io.crate.sql.tree.RerouteOption;
import io.crate.sql.tree.ResetStatement;
import io.crate.sql.tree.RestoreSnapshot;
import io.crate.sql.tree.RevokePrivilege;
import io.crate.sql.tree.SearchedCaseExpression;
import io.crate.sql.tree.Select;
import io.crate.sql.tree.SelectItem;
import io.crate.sql.tree.SetSessionAuthorizationStatement;
import io.crate.sql.tree.SetStatement;
import io.crate.sql.tree.SetTransactionStatement;
import io.crate.sql.tree.ShowColumns;
import io.crate.sql.tree.ShowCreateTable;
import io.crate.sql.tree.ShowSchemas;
import io.crate.sql.tree.ShowSessionParameter;
import io.crate.sql.tree.ShowTables;
import io.crate.sql.tree.ShowTransaction;
import io.crate.sql.tree.SimpleCaseExpression;
import io.crate.sql.tree.SingleColumn;
import io.crate.sql.tree.SortItem;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SubqueryExpression;
import io.crate.sql.tree.SubscriptExpression;
import io.crate.sql.tree.SwapTable;
import io.crate.sql.tree.Table;
import io.crate.sql.tree.TableElement;
import io.crate.sql.tree.TableFunction;
import io.crate.sql.tree.TableSubquery;
import io.crate.sql.tree.TokenFilters;
import io.crate.sql.tree.Tokenizer;
import io.crate.sql.tree.TrimMode;
import io.crate.sql.tree.TryCast;
import io.crate.sql.tree.Union;
import io.crate.sql.tree.Update;
import io.crate.sql.tree.Values;
import io.crate.sql.tree.ValuesList;
import io.crate.sql.tree.WhenClause;
import io.crate.sql.tree.Window;
import io.crate.sql.tree.WindowFrame;
import io.crate.sql.tree.With;
import io.crate.sql.tree.WithQuery;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jetbrains.annotations.Nullable;

class AstBuilder
extends SqlBaseParserBaseVisitor<Node> {
    public static final String UNSUPPORTED_OP_STR = "Unsupported operator: ";
    private int parameterPosition = 1;
    private static final String CLUSTER = "CLUSTER";
    private static final String SCHEMA = "SCHEMA";
    private static final String TABLE = "TABLE";
    private static final String VIEW = "VIEW";
    @Nullable
    private final Function<String, Expression> parseStringLiteral;

    public AstBuilder(@Nullable Function<String, Expression> parseStringLiteral) {
        this.parseStringLiteral = parseStringLiteral;
    }

    @Override
    public Node visitSingleStatement(SqlBaseParser.SingleStatementContext context) {
        return (Node)this.visit((ParseTree)context.statement());
    }

    @Override
    public Node visitStatements(SqlBaseParser.StatementsContext ctx) {
        return new MultiStatement(this.visitCollection(ctx.statement(), Statement.class));
    }

    @Override
    public Node visitSingleExpression(SqlBaseParser.SingleExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expr());
    }

    @Override
    public Node visitBegin(SqlBaseParser.BeginContext context) {
        return new BeginStatement();
    }

    @Override
    public Node visitStartTransaction(SqlBaseParser.StartTransactionContext context) {
        return new BeginStatement();
    }

    @Override
    public Node visitAnalyze(SqlBaseParser.AnalyzeContext ctx) {
        return new AnalyzeStatement();
    }

    @Override
    public Node visitDeclare(SqlBaseParser.DeclareContext ctx) {
        Declare.Hold hold = ctx.HOLD() == null ? Declare.Hold.WITHOUT : (ctx.WITH() == null ? Declare.Hold.WITHOUT : Declare.Hold.WITH);
        SqlBaseParser.DeclareCursorParamsContext declareCursorParams = ctx.declareCursorParams();
        Query query = (Query)ctx.queryNoWith().accept(this);
        return new Declare(this.getIdentText(ctx.ident()), hold, !declareCursorParams.BINARY().isEmpty(), declareCursorParams.NO().isEmpty() && !declareCursorParams.SCROLL().isEmpty(), query);
    }

    @Override
    public Node visitFetch(SqlBaseParser.FetchContext ctx) {
        Fetch.ScrollMode scrollMode;
        String cursorName = this.getIdentText(ctx.ident());
        SqlBaseParser.DirectionContext direction = ctx.direction();
        long count = 1L;
        if (direction == null) {
            scrollMode = Fetch.ScrollMode.MOVE;
        } else if (direction.FIRST() != null) {
            scrollMode = Fetch.ScrollMode.ABSOLUTE;
            count = 1L;
        } else if (direction.LAST() != null) {
            scrollMode = Fetch.ScrollMode.ABSOLUTE;
            count = -1L;
        } else if (direction.ABSOLUTE() != null) {
            scrollMode = Fetch.ScrollMode.ABSOLUTE;
            count = Long.parseLong(direction.integerLiteral().getText());
        } else if (direction.RELATIVE() != null) {
            scrollMode = Fetch.ScrollMode.RELATIVE;
            count = Long.parseLong(direction.integerLiteral().getText());
            if (direction.MINUS() != null) {
                count *= -1L;
            }
        } else {
            scrollMode = Fetch.ScrollMode.MOVE;
            if (direction.ALL() != null) {
                count = Long.MAX_VALUE;
            } else if (direction.integerLiteral() != null) {
                count = Long.parseLong(direction.integerLiteral().getText());
            }
            if (direction.BACKWARD() != null) {
                count *= -1L;
            }
        }
        return new Fetch(scrollMode, count, cursorName);
    }

    @Override
    public Node visitClose(SqlBaseParser.CloseContext ctx) {
        if (ctx.ALL() == null) {
            return new Close(this.getIdentText(ctx.ident()));
        }
        return new Close(null);
    }

    @Override
    public Node visitDiscard(SqlBaseParser.DiscardContext ctx) {
        DiscardStatement.Target target;
        if (ctx.ALL() != null) {
            target = DiscardStatement.Target.ALL;
        } else if (ctx.PLANS() != null) {
            target = DiscardStatement.Target.PLANS;
        } else if (ctx.SEQUENCES() != null) {
            target = DiscardStatement.Target.SEQUENCES;
        } else if (ctx.TEMP() != null || ctx.TEMPORARY() != null) {
            target = DiscardStatement.Target.TEMPORARY;
        } else {
            throw new IllegalStateException("Unexpected DiscardContext: " + String.valueOf((Object)ctx));
        }
        return new DiscardStatement(target);
    }

    @Override
    public Node visitIntervalLiteral(SqlBaseParser.IntervalLiteralContext context) {
        IntervalLiteral.IntervalField startField = AstBuilder.getIntervalFieldType((Token)context.from.getChild(0).getPayload());
        IntervalLiteral.IntervalField endField = null;
        if (context.to != null) {
            Token token = (Token)context.to.getChild(0).getPayload();
            endField = AstBuilder.getIntervalFieldType(token);
        }
        if (endField != null && startField.compareTo(endField) > 0) {
            throw new IllegalArgumentException("Startfield must be less significant than Endfield");
        }
        IntervalLiteral.Sign sign = IntervalLiteral.Sign.PLUS;
        if (context.sign != null) {
            sign = AstBuilder.getIntervalSign(context.sign);
        }
        return new IntervalLiteral(((StringLiteral)this.visit((ParseTree)context.stringLiteral())).getValue(), sign, startField, endField);
    }

    private static IntervalLiteral.Sign getIntervalSign(Token token) {
        return switch (token.getType()) {
            case 297 -> IntervalLiteral.Sign.MINUS;
            case 296 -> IntervalLiteral.Sign.PLUS;
            default -> throw new IllegalArgumentException("Unsupported sign: " + token.getText());
        };
    }

    private static IntervalLiteral.IntervalField getIntervalFieldType(Token token) {
        return switch (token.getType()) {
            case 51 -> IntervalLiteral.IntervalField.YEAR;
            case 52 -> IntervalLiteral.IntervalField.MONTH;
            case 53 -> IntervalLiteral.IntervalField.DAY;
            case 54 -> IntervalLiteral.IntervalField.HOUR;
            case 55 -> IntervalLiteral.IntervalField.MINUTE;
            case 56 -> IntervalLiteral.IntervalField.SECOND;
            case 57 -> IntervalLiteral.IntervalField.MILLISECOND;
            default -> throw new IllegalArgumentException("Unsupported interval field: " + token.getText());
        };
    }

    @Override
    public Node visitCommit(SqlBaseParser.CommitContext context) {
        return new CommitStatement();
    }

    @Override
    public Node visitOptimize(SqlBaseParser.OptimizeContext context) {
        return new OptimizeStatement<Expression>(this.visitCollection(context.tableWithPartitions().tableWithPartition(), Table.class), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitCreateTable(SqlBaseParser.CreateTableContext context) {
        boolean notExists = context.EXISTS() != null;
        SqlBaseParser.PartitionedByOrClusteredIntoContext tableOptsCtx = context.partitionedByOrClusteredInto();
        Optional clusteredBy = this.visitIfPresent(tableOptsCtx.clusteredBy(), ClusteredBy.class);
        Optional partitionedBy = this.visitIfPresent(tableOptsCtx.partitionedBy(), PartitionedBy.class);
        List tableElements = Lists.map(context.tableElement(), x -> (TableElement)this.visit((ParseTree)x));
        return new CreateTable<Expression>((Table)this.visit((ParseTree)context.table()), tableElements, partitionedBy, clusteredBy, this.extractGenericProperties(context.withProperties()), notExists);
    }

    @Override
    public Node visitCreateForeignTable(SqlBaseParser.CreateForeignTableContext ctx) {
        QualifiedName name = this.getQualifiedName(ctx.tableName);
        List tableElements = Lists.map(ctx.tableElement(), x -> (TableElement)this.visit((ParseTree)x));
        String server = this.getIdentText(ctx.server);
        return new CreateForeignTable(name, ctx.EXISTS() != null, tableElements, server, this.getOptions(ctx.kvOptions()));
    }

    @Override
    public Node visitDropForeignTable(SqlBaseParser.DropForeignTableContext ctx) {
        List<QualifiedName> names = this.getIdents(ctx.names.qname());
        boolean ifExists = ctx.EXISTS() != null;
        CascadeMode cascadeMode = ctx.CASCADE() == null ? CascadeMode.RESTRICT : CascadeMode.CASCADE;
        return new DropForeignTable(names, ifExists, cascadeMode);
    }

    @Override
    public Node visitCreateUserMapping(SqlBaseParser.CreateUserMappingContext ctx) {
        boolean ifNotExists = ctx.EXISTS() != null;
        SqlBaseParser.MappedUserContext mappedUser = ctx.mappedUser();
        String userName = mappedUser.userName == null ? null : this.getIdentText(mappedUser.userName);
        String server = this.getIdentText(ctx.server);
        Map<String, Expression> options = this.getOptions(ctx.kvOptions());
        return new CreateUserMapping(ifNotExists, userName, server, options);
    }

    @Override
    public Node visitDropUserMapping(SqlBaseParser.DropUserMappingContext ctx) {
        boolean ifExists = ctx.EXISTS() != null;
        SqlBaseParser.MappedUserContext mappedUser = ctx.mappedUser();
        String userName = mappedUser.userName == null ? null : this.getIdentText(mappedUser.userName);
        String server = this.getIdentText(ctx.server);
        return new DropUserMapping(userName, ifExists, server);
    }

    @Override
    public Node visitCreateTableAs(SqlBaseParser.CreateTableAsContext context) {
        return new CreateTableAs((Table)this.visit((ParseTree)context.table()), (Query)this.visit((ParseTree)context.insertSource().query()), context.EXISTS() != null);
    }

    @Override
    public Node visitAlterClusterSwapTable(SqlBaseParser.AlterClusterSwapTableContext ctx) {
        return new SwapTable<Expression>(this.getQualifiedName(ctx.source), this.getQualifiedName(ctx.target), this.extractGenericProperties(ctx.withProperties()));
    }

    @Override
    public Node visitAlterClusterGCDanglingArtifacts(SqlBaseParser.AlterClusterGCDanglingArtifactsContext ctx) {
        return GCDanglingArtifacts.INSTANCE;
    }

    @Override
    public Node visitAlterClusterDecommissionNode(SqlBaseParser.AlterClusterDecommissionNodeContext ctx) {
        return new DecommissionNodeStatement<Node>((Node)this.visit((ParseTree)ctx.node));
    }

    @Override
    public Node visitCreateView(SqlBaseParser.CreateViewContext ctx) {
        return new CreateView(this.getQualifiedName(ctx.qname()), (Query)this.visit((ParseTree)ctx.queryOptParens()), ctx.REPLACE() != null);
    }

    @Override
    public Node visitQueryOptParens(SqlBaseParser.QueryOptParensContext ctx) {
        SqlBaseParser.QueryContext query = ctx.query();
        if (query == null) {
            return ctx.queryOptParens().accept(this);
        }
        return query.accept(this);
    }

    @Override
    public Node visitDropView(SqlBaseParser.DropViewContext ctx) {
        return new DropView(this.getQualifiedNames(ctx.qnames()), ctx.EXISTS() != null);
    }

    @Override
    public Node visitCreateBlobTable(SqlBaseParser.CreateBlobTableContext context) {
        return new CreateBlobTable<Expression>((Table)this.visit((ParseTree)context.table()), this.visitIfPresent(context.numShards, ClusteredBy.class), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitCreateRepository(SqlBaseParser.CreateRepositoryContext context) {
        return new CreateRepository<Expression>(this.getIdentText(context.name), this.getIdentText(context.type), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitCreateSnapshot(SqlBaseParser.CreateSnapshotContext context) {
        if (context.ALL() != null) {
            return new CreateSnapshot<Expression>(this.getQualifiedName(context.qname()), this.extractGenericProperties(context.withProperties()));
        }
        return new CreateSnapshot<Expression>(this.getQualifiedName(context.qname()), this.visitCollection(context.tableWithPartitions().tableWithPartition(), Table.class), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitCreateAnalyzer(SqlBaseParser.CreateAnalyzerContext context) {
        return new CreateAnalyzer(this.getIdentText(context.name), this.getIdentText(context.extendedName), this.visitCollection(context.analyzerElement(), AnalyzerElement.class));
    }

    @Override
    public Node visitDropAnalyzer(SqlBaseParser.DropAnalyzerContext ctx) {
        return new DropAnalyzer(this.getIdentText(ctx.name));
    }

    @Override
    public Node visitCreateRole(SqlBaseParser.CreateRoleContext ctx) {
        GenericProperties<Object> properties = GenericProperties.empty();
        if (ctx.spaceSeparatedIdents() != null) {
            List<SqlBaseParser.IdentWithOrWithoutValueContext> idents = ctx.spaceSeparatedIdents().identWithOrWithoutValue();
            HashMap<String, Expression> options = HashMap.newHashMap(idents.size());
            for (SqlBaseParser.IdentWithOrWithoutValueContext identCtx : idents) {
                Optional<Expression> value = this.visitIfPresent(identCtx.parameterOrSimpleLiteral(), Expression.class);
                if (value.isEmpty()) {
                    options.put(this.getIdentText(identCtx.ident()), NullLiteral.INSTANCE);
                    continue;
                }
                options.put(this.getIdentText(identCtx.ident()), value.get());
            }
            properties = new GenericProperties(options);
        } else if (ctx.withProperties() != null) {
            properties = this.extractGenericProperties(ctx.withProperties());
        }
        return new CreateRole(this.getIdentText(ctx.name), ctx.USER() != null, properties);
    }

    @Override
    public Node visitDropRole(SqlBaseParser.DropRoleContext context) {
        return new DropRole(this.getIdentText(context.name), context.EXISTS() != null);
    }

    @Override
    public Node visitGrantPrivilege(SqlBaseParser.GrantPrivilegeContext context) {
        List<String> usernames = this.identsToStrings(context.users.ident());
        SecurableAndIdent securableAndIdent = this.getSecurableAndIdentsForPrivileges(context.ON() == null, context.securable(), context.qnames());
        if (context.ALL() != null) {
            return new GrantPrivilege(usernames, securableAndIdent.securable, securableAndIdent.idents);
        }
        List<String> permissions = this.identsToStrings(context.priviliges.ident());
        return new GrantPrivilege(usernames, permissions, securableAndIdent.securable, securableAndIdent.idents);
    }

    @Override
    public Node visitDenyPrivilege(SqlBaseParser.DenyPrivilegeContext context) {
        List<String> usernames = this.identsToStrings(context.users.ident());
        SecurableAndIdent securableAndIdent = this.getSecurableAndIdentsForPrivileges(context.ON() == null, context.securable(), context.qnames());
        if (context.ALL() != null) {
            return new DenyPrivilege(usernames, securableAndIdent.securable, securableAndIdent.idents);
        }
        List<String> permissions = this.identsToStrings(context.priviliges.ident());
        return new DenyPrivilege(usernames, permissions, securableAndIdent.securable, securableAndIdent.idents);
    }

    @Override
    public Node visitRevokePrivilege(SqlBaseParser.RevokePrivilegeContext context) {
        List<String> usernames = this.identsToStrings(context.users.ident());
        SecurableAndIdent securableAndIdent = this.getSecurableAndIdentsForPrivileges(context.ON() == null, context.securable(), context.qnames());
        if (context.ALL() != null) {
            return new RevokePrivilege(usernames, securableAndIdent.securable, securableAndIdent.idents);
        }
        List<String> permissions = this.identsToStrings(context.privileges.ident());
        return new RevokePrivilege(usernames, permissions, securableAndIdent.securable, securableAndIdent.idents);
    }

    @Override
    public Node visitCharFilters(SqlBaseParser.CharFiltersContext context) {
        return new CharFilters(this.visitCollection(context.namedProperties(), NamedProperties.class));
    }

    @Override
    public Node visitTokenFilters(SqlBaseParser.TokenFiltersContext context) {
        return new TokenFilters(this.visitCollection(context.namedProperties(), NamedProperties.class));
    }

    @Override
    public Node visitTokenizer(SqlBaseParser.TokenizerContext context) {
        return new Tokenizer((NamedProperties)this.visit((ParseTree)context.namedProperties()));
    }

    @Override
    public Node visitNamedProperties(SqlBaseParser.NamedPropertiesContext context) {
        return new NamedProperties<Expression>(this.getIdentText(context.ident()), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitRestore(SqlBaseParser.RestoreContext context) {
        if (context.ALL() != null) {
            return new RestoreSnapshot<Expression>(this.getQualifiedName(context.qname()), RestoreSnapshot.Mode.ALL, this.extractGenericProperties(context.withProperties()));
        }
        if (context.METADATA() != null) {
            return new RestoreSnapshot<Expression>(this.getQualifiedName(context.qname()), RestoreSnapshot.Mode.METADATA, this.extractGenericProperties(context.withProperties()));
        }
        if (context.TABLE() != null) {
            return new RestoreSnapshot<Expression>(this.getQualifiedName(context.qname()), RestoreSnapshot.Mode.TABLE, this.extractGenericProperties(context.withProperties()), List.of(), this.visitCollection(context.tableWithPartitions().tableWithPartition(), Table.class));
        }
        return new RestoreSnapshot<Expression>(this.getQualifiedName(context.qname()), RestoreSnapshot.Mode.CUSTOM, this.extractGenericProperties(context.withProperties()), this.identsToStrings(context.metatypes.ident()));
    }

    @Override
    public Node visitShowCreateTable(SqlBaseParser.ShowCreateTableContext context) {
        return new ShowCreateTable((Table)this.visit((ParseTree)context.table()));
    }

    @Override
    public Node visitShowTransaction(SqlBaseParser.ShowTransactionContext context) {
        return new ShowTransaction();
    }

    @Override
    public Node visitShowSessionParameter(SqlBaseParser.ShowSessionParameterContext ctx) {
        if (ctx.ALL() != null) {
            return new ShowSessionParameter(null);
        }
        return new ShowSessionParameter(this.getQualifiedName(ctx.qname()));
    }

    @Override
    public Node visitDropTable(SqlBaseParser.DropTableContext context) {
        return new DropTable((Table)this.visit((ParseTree)context.table()), context.EXISTS() != null);
    }

    @Override
    public Node visitDropRepository(SqlBaseParser.DropRepositoryContext context) {
        return new DropRepository(this.getIdentText(context.ident()));
    }

    @Override
    public Node visitDropBlobTable(SqlBaseParser.DropBlobTableContext context) {
        return new DropBlobTable((Table)this.visit((ParseTree)context.table()), context.EXISTS() != null);
    }

    @Override
    public Node visitDropSnapshot(SqlBaseParser.DropSnapshotContext context) {
        return new DropSnapshot(this.getQualifiedName(context.qname()));
    }

    @Override
    public Node visitCopyFrom(SqlBaseParser.CopyFromContext context) {
        boolean returnSummary = context.SUMMARY() != null;
        return new CopyFrom<Expression>((Table)this.visit((ParseTree)context.tableWithPartition()), (List<String>)(context.ident() == null ? Collections.emptyList() : this.identsToStrings(context.ident())), (Expression)this.visit((ParseTree)context.path), this.extractGenericProperties(context.withProperties()), returnSummary);
    }

    @Override
    public Node visitCopyTo(SqlBaseParser.CopyToContext context) {
        return new CopyTo<Expression>((Table)this.visit((ParseTree)context.tableWithPartition()), (List<Expression>)(context.columns() == null ? Collections.emptyList() : this.visitCollection(context.columns().primaryExpression(), Expression.class)), this.visitIfPresent(context.where(), Expression.class), context.DIRECTORY() != null, (Expression)this.visit((ParseTree)context.path), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitInsert(SqlBaseParser.InsertContext context) throws IllegalArgumentException {
        Table table;
        List<String> columns = this.identsToStrings(context.ident());
        Node node = (Node)this.visit((ParseTree)context.table());
        try {
            table = (Table)node;
        }
        catch (ClassCastException e) {
            TableFunction tf = (TableFunction)node;
            Iterator<Expression> iterator = tf.functionCall().getArguments().iterator();
            if (iterator.hasNext()) {
                QualifiedNameReference ref;
                Expression ex = iterator.next();
                if (ex instanceof QualifiedNameReference && (ref = (QualifiedNameReference)ex).getName().getParts().size() > 1) {
                    throw new IllegalArgumentException("Column references used in INSERT INTO <tbl> (...) must use the column name. They cannot qualify catalog, schema or table. Got `" + ref.getName().toString() + "`");
                }
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid column reference %s used in INSERT INTO statement", ex.toString()));
            }
            throw e;
        }
        return new Insert(table, (Query)this.visit((ParseTree)context.insertSource().query()), columns, this.getReturningItems(context.returning()), this.createDuplicateKeyContext(context));
    }

    private Insert.DuplicateKeyContext<?> createDuplicateKeyContext(SqlBaseParser.InsertContext context) {
        if (context.onConflict() != null) {
            SqlBaseParser.OnConflictContext onConflictContext = context.onConflict();
            SqlBaseParser.ConflictTargetContext conflictTarget = onConflictContext.conflictTarget();
            List<Object> conflictColumns = conflictTarget == null ? List.of() : this.visitCollection(conflictTarget.subscriptSafe(), Expression.class);
            if (onConflictContext.NOTHING() != null) {
                return new Insert.DuplicateKeyContext<Object>(Insert.DuplicateKeyContext.Type.ON_CONFLICT_DO_NOTHING, Collections.emptyList(), conflictColumns);
            }
            if (conflictColumns.isEmpty()) {
                throw new IllegalStateException("ON CONFLICT <conflict_target> <- conflict_target missing");
            }
            List assignments = Lists.map(onConflictContext.assignment(), x -> (Assignment)this.visit((ParseTree)x));
            return new Insert.DuplicateKeyContext<Object>(Insert.DuplicateKeyContext.Type.ON_CONFLICT_DO_UPDATE_SET, assignments, conflictColumns);
        }
        return Insert.DuplicateKeyContext.none();
    }

    @Override
    public Node visitValues(SqlBaseParser.ValuesContext context) {
        return new ValuesList(this.visitCollection(context.expr(), Expression.class));
    }

    @Override
    public Node visitDelete(SqlBaseParser.DeleteContext context) {
        return new Delete((Relation)this.visit((ParseTree)context.aliasedRelation()), this.visitIfPresent(context.where(), Expression.class));
    }

    @Override
    public Node visitUpdate(SqlBaseParser.UpdateContext context) {
        List assignments = Lists.map(context.assignment(), x -> (Assignment)this.visit((ParseTree)x));
        return new Update((Relation)this.visit((ParseTree)context.aliasedRelation()), assignments, this.visitIfPresent(context.where(), Expression.class), this.getReturningItems(context.returning()));
    }

    @Override
    public Node visitSet(SqlBaseParser.SetContext context) {
        Assignment<?> setAssignment = this.prepareSetAssignment(context);
        if (context.LOCAL() != null) {
            return new SetStatement(SetStatement.Scope.LOCAL, setAssignment);
        }
        return new SetStatement(SetStatement.Scope.SESSION, setAssignment);
    }

    private Assignment<?> prepareSetAssignment(SqlBaseParser.SetContext context) {
        QualifiedNameReference settingName = new QualifiedNameReference(this.getQualifiedName(context.qname()));
        if (context.DEFAULT() != null) {
            return new Assignment(settingName, List.of());
        }
        return new Assignment<List<Expression>>((List<Expression>)((Object)settingName), this.visitCollection(context.setExpr(), Expression.class));
    }

    @Override
    public Node visitSetGlobal(SqlBaseParser.SetGlobalContext context) {
        List assignments = Lists.map(context.setGlobalAssignment(), x -> (Assignment)this.visit((ParseTree)x));
        if (context.PERSISTENT() != null) {
            return new SetStatement(SetStatement.Scope.GLOBAL, SetStatement.SettingType.PERSISTENT, assignments);
        }
        return new SetStatement(SetStatement.Scope.GLOBAL, assignments);
    }

    @Override
    public Node visitSetTimeZone(SqlBaseParser.SetTimeZoneContext ctx) {
        Expression value = ctx.DEFAULT() != null ? new StringLiteral(ctx.DEFAULT().getText()) : (ctx.LOCAL() != null ? new StringLiteral(ctx.LOCAL().getText()) : (Expression)this.visit((ParseTree)ctx.stringLiteral()));
        Assignment<StringLiteral> assignment = new Assignment<StringLiteral>(new StringLiteral("time zone"), (StringLiteral)value);
        return new SetStatement(SetStatement.Scope.TIME_ZONE, List.of(assignment));
    }

    @Override
    public Node visitSetTransaction(SqlBaseParser.SetTransactionContext ctx) {
        List modes = Lists.map(ctx.transactionMode(), AstBuilder::getTransactionMode);
        return new SetTransactionStatement(modes);
    }

    private static SetTransactionStatement.TransactionMode getTransactionMode(SqlBaseParser.TransactionModeContext transactionModeCtx) {
        if (transactionModeCtx.ISOLATION() != null) {
            SqlBaseParser.IsolationLevelContext isolationLevel = transactionModeCtx.isolationLevel();
            if (isolationLevel.COMMITTED() != null) {
                return SetTransactionStatement.IsolationLevel.READ_COMMITTED;
            }
            if (isolationLevel.UNCOMMITTED() != null) {
                return SetTransactionStatement.IsolationLevel.READ_UNCOMMITTED;
            }
            if (isolationLevel.REPEATABLE() != null) {
                return SetTransactionStatement.IsolationLevel.REPEATABLE_READ;
            }
            return SetTransactionStatement.IsolationLevel.SERIALIZABLE;
        }
        if (transactionModeCtx.READ() != null) {
            return SetTransactionStatement.ReadMode.READ_ONLY;
        }
        if (transactionModeCtx.WRITE() != null) {
            return SetTransactionStatement.ReadMode.READ_WRITE;
        }
        if (transactionModeCtx.NOT() != null) {
            return new SetTransactionStatement.Deferrable(true);
        }
        if (transactionModeCtx.DEFERRABLE() != null) {
            return new SetTransactionStatement.Deferrable(false);
        }
        throw new IllegalStateException("Unexpected TransactionModeContext: " + String.valueOf((Object)transactionModeCtx));
    }

    @Override
    public Node visitResetGlobal(SqlBaseParser.ResetGlobalContext context) {
        return new ResetStatement<Expression>(this.visitCollection(context.primaryExpression(), Expression.class));
    }

    @Override
    public Node visitSetSessionAuthorization(SqlBaseParser.SetSessionAuthorizationContext context) {
        SetSessionAuthorizationStatement.Scope scope = context.LOCAL() != null ? SetSessionAuthorizationStatement.Scope.LOCAL : SetSessionAuthorizationStatement.Scope.SESSION;
        if (context.DEFAULT() != null) {
            return new SetSessionAuthorizationStatement(scope);
        }
        Node userNameLiteral = (Node)this.visit((ParseTree)context.username);
        assert (userNameLiteral instanceof StringLiteral) : "username must be a StringLiteral because the parser grammar is restricted to string literals";
        String userName = ((StringLiteral)userNameLiteral).getValue();
        return new SetSessionAuthorizationStatement(userName, scope);
    }

    @Override
    public Node visitResetSessionAuthorization(SqlBaseParser.ResetSessionAuthorizationContext ctx) {
        return new SetSessionAuthorizationStatement(SetSessionAuthorizationStatement.Scope.SESSION);
    }

    @Override
    public Node visitKill(SqlBaseParser.KillContext context) {
        return new KillStatement<Expression>(this.visitIfPresent(context.jobId, Expression.class).orElse(null));
    }

    @Override
    public Node visitDeallocate(SqlBaseParser.DeallocateContext context) {
        if (context.ALL() != null) {
            return new DeallocateStatement();
        }
        return new DeallocateStatement((Expression)this.visit((ParseTree)context.prepStmt));
    }

    @Override
    public Node visitExplain(SqlBaseParser.ExplainContext context) {
        if (context.ANALYZE() != null) {
            return new Explain((Statement)this.visit((ParseTree)context.statement()), Map.of(Explain.Option.ANALYZE, true));
        }
        if (context.VERBOSE() != null) {
            Map<Explain.Option, Boolean> options = Map.of(Explain.Option.COSTS, true, Explain.Option.VERBOSE, true);
            return new Explain((Statement)this.visit((ParseTree)context.statement()), options);
        }
        if (context.explainOptions() == null) {
            return new Explain((Statement)this.visit((ParseTree)context.statement()), Map.of(Explain.Option.COSTS, true));
        }
        LinkedHashMap<Explain.Option, Boolean> options = new LinkedHashMap<Explain.Option, Boolean>();
        for (SqlBaseParser.ExplainOptionsContext explainOptions : context.explainOptions()) {
            for (SqlBaseParser.ExplainOptionContext explainOptionContext : explainOptions.explainOption()) {
                if (explainOptionContext.COSTS() != null) {
                    options.put(Explain.Option.COSTS, this.getBooleanOrNull(explainOptionContext));
                    continue;
                }
                if (explainOptionContext.ANALYZE() != null) {
                    options.put(Explain.Option.ANALYZE, this.getBooleanOrNull(explainOptionContext));
                    continue;
                }
                if (explainOptionContext.VERBOSE() == null) continue;
                options.put(Explain.Option.VERBOSE, this.getBooleanOrNull(explainOptionContext));
            }
        }
        return new Explain((Statement)this.visit((ParseTree)context.statement()), options);
    }

    private Boolean getBooleanOrNull(SqlBaseParser.ExplainOptionContext context) {
        if (context.booleanLiteral() == null) {
            return null;
        }
        return ((BooleanLiteral)this.visitBooleanLiteral(context.booleanLiteral())).getValue();
    }

    @Override
    public Node visitShowTables(SqlBaseParser.ShowTablesContext context) {
        return new ShowTables(context.qname() == null ? null : this.getQualifiedName(context.qname()), AstBuilder.getUnquotedText(context.pattern), this.visitIfPresent(context.where(), Expression.class));
    }

    @Override
    public Node visitShowSchemas(SqlBaseParser.ShowSchemasContext context) {
        return new ShowSchemas(AstBuilder.getUnquotedText(context.pattern), this.visitIfPresent(context.where(), Expression.class));
    }

    @Override
    public Node visitShowColumns(SqlBaseParser.ShowColumnsContext context) {
        return new ShowColumns(this.getQualifiedName(context.tableName), context.schema == null ? null : this.getQualifiedName(context.schema), this.visitIfPresent(context.where(), Expression.class), AstBuilder.getUnquotedText(context.pattern));
    }

    @Override
    public Node visitRefreshTable(SqlBaseParser.RefreshTableContext context) {
        return new RefreshStatement(this.visitCollection(context.tableWithPartitions().tableWithPartition(), Table.class));
    }

    @Override
    public Node visitTableOnly(SqlBaseParser.TableOnlyContext context) {
        return new Table(this.getQualifiedName(context.qname()));
    }

    @Override
    public Node visitTableWithPartition(SqlBaseParser.TableWithPartitionContext context) {
        return new Table(this.getQualifiedName(context.qname()), this.visitCollection(context.assignment(), Assignment.class));
    }

    @Override
    public Node visitCreateFunction(SqlBaseParser.CreateFunctionContext context) {
        QualifiedName functionName = this.getQualifiedName(context.name);
        AstBuilder.validateFunctionName(functionName);
        return new CreateFunction<Object>(functionName, context.REPLACE() != null, this.visitCollection(context.functionArgument(), FunctionArgument.class), (ColumnType)this.visit((ParseTree)context.returnType), this.visit((ParseTree)context.language), this.visit((ParseTree)context.body));
    }

    @Override
    public Node visitDropFunction(SqlBaseParser.DropFunctionContext context) {
        QualifiedName functionName = this.getQualifiedName(context.name);
        AstBuilder.validateFunctionName(functionName);
        return new DropFunction(functionName, context.EXISTS() != null, this.visitCollection(context.functionArgument(), FunctionArgument.class));
    }

    @Override
    public Node visitCreatePublication(SqlBaseParser.CreatePublicationContext ctx) {
        List<QualifiedName> tables = ctx.qname().stream().map(this::getQualifiedName).toList();
        return new CreatePublication(this.getIdentText(ctx.name), ctx.ALL() != null, tables);
    }

    @Override
    public Node visitDropPublication(SqlBaseParser.DropPublicationContext ctx) {
        return new DropPublication(this.getIdentText(ctx.name), ctx.EXISTS() != null);
    }

    @Override
    public Node visitAlterPublication(SqlBaseParser.AlterPublicationContext ctx) {
        AlterPublication.Operation op = ctx.ADD() != null ? AlterPublication.Operation.ADD : (ctx.SET() != null ? AlterPublication.Operation.SET : AlterPublication.Operation.DROP);
        List<QualifiedName> tables = ctx.qname().stream().map(this::getQualifiedName).toList();
        return new AlterPublication(this.getIdentText(ctx.name), op, tables);
    }

    @Override
    public Node visitCreateSubscription(SqlBaseParser.CreateSubscriptionContext ctx) {
        return new CreateSubscription<Expression>(this.getIdentText(ctx.name), (Expression)this.visit((ParseTree)ctx.conninfo), this.identsToStrings(ctx.publications.ident()), this.extractGenericProperties(ctx.withProperties()));
    }

    @Override
    public Node visitDropSubscription(SqlBaseParser.DropSubscriptionContext ctx) {
        return new DropSubscription(this.getIdentText(ctx.name), ctx.EXISTS() != null);
    }

    @Override
    public Node visitAlterSubscription(SqlBaseParser.AlterSubscriptionContext ctx) {
        AlterSubscription.Mode mode = ctx.alterSubscriptionMode().ENABLE() != null ? AlterSubscription.Mode.ENABLE : AlterSubscription.Mode.DISABLE;
        return new AlterSubscription(this.getIdentText(ctx.name), mode);
    }

    @Override
    public Node visitNamedQuery(SqlBaseParser.NamedQueryContext ctx) {
        return new WithQuery(this.getIdentText(ctx.ident()), (Query)this.visit((ParseTree)ctx.query()), this.getColumnAliases(ctx.aliasedColumns()));
    }

    @Override
    public Node visitWith(SqlBaseParser.WithContext ctx) {
        return new With(this.visitCollection(ctx.namedQuery(), WithQuery.class));
    }

    @Override
    public Node visitColumnDefinition(SqlBaseParser.ColumnDefinitionContext context) {
        return new ColumnDefinition(this.getIdentText(context.ident()), this.visitOptionalContext(context.dataType(), ColumnType.class), this.visitCollection(context.columnConstraint(), ColumnConstraint.class));
    }

    @Override
    public Node visitColumnConstraintPrimaryKey(SqlBaseParser.ColumnConstraintPrimaryKeyContext context) {
        return new PrimaryKeyColumnConstraint(this.getIdentText(context.primaryKeyContraint().name));
    }

    @Override
    public Node visitColumnConstraintNotNull(SqlBaseParser.ColumnConstraintNotNullContext context) {
        return new NotNullColumnConstraint();
    }

    @Override
    public Node visitColumnGeneratedConstraint(SqlBaseParser.ColumnGeneratedConstraintContext context) {
        String name = context.CONSTRAINT() != null ? this.getIdentText(context.name) : null;
        Expression expression = (Expression)this.visit((ParseTree)context.expr());
        String expressionStr = ExpressionFormatter.formatStandaloneExpression(expression);
        return new GeneratedExpressionConstraint<Expression>(name, expression, expressionStr);
    }

    @Override
    public Node visitColumnDefaultConstraint(SqlBaseParser.ColumnDefaultConstraintContext context) {
        String name = context.CONSTRAINT() != null ? this.getIdentText(context.name) : null;
        Expression expression = (Expression)this.visit((ParseTree)context.expr());
        String expressionStr = ExpressionFormatter.formatStandaloneExpression(expression);
        return new DefaultConstraint<Expression>(name, expression, expressionStr);
    }

    @Override
    public Node visitColumnConstraintNull(SqlBaseParser.ColumnConstraintNullContext ctx) {
        return new NullColumnConstraint();
    }

    @Override
    public Node visitPrimaryKeyConstraintTableLevel(SqlBaseParser.PrimaryKeyConstraintTableLevelContext ctx) {
        return new PrimaryKeyConstraint<Expression>(this.getIdentText(ctx.primaryKeyContraint().name), this.visitCollection(ctx.columns().primaryExpression(), Expression.class));
    }

    @Override
    public Node visitTableCheckConstraint(SqlBaseParser.TableCheckConstraintContext context) {
        SqlBaseParser.CheckConstraintContext ctx = context.checkConstraint();
        String name = ctx.CONSTRAINT() != null ? this.getIdentText(ctx.name) : null;
        Expression expression = (Expression)this.visit((ParseTree)ctx.expression);
        String expressionStr = ExpressionFormatter.formatStandaloneExpression(expression);
        return new CheckConstraint<Expression>(name, expression, expressionStr);
    }

    @Override
    public Node visitColumnCheckConstraint(SqlBaseParser.ColumnCheckConstraintContext context) {
        SqlBaseParser.CheckConstraintContext ctx = context.checkConstraint();
        String name = ctx.CONSTRAINT() != null ? this.getIdentText(ctx.name) : null;
        Expression expression = (Expression)this.visit((ParseTree)ctx.expression);
        String expressionStr = ExpressionFormatter.formatStandaloneExpression(expression);
        return new CheckColumnConstraint<Expression>(name, null, expression, expressionStr);
    }

    @Override
    public Node visitDropCheckConstraint(SqlBaseParser.DropCheckConstraintContext context) {
        Table table = (Table)this.visit((ParseTree)context.alterTableDefinition());
        return new DropCheckConstraint(table, this.getIdentText(context.ident()));
    }

    @Override
    public Node visitColumnIndexOff(SqlBaseParser.ColumnIndexOffContext context) {
        return IndexColumnConstraint.off();
    }

    @Override
    public Node visitColumnIndexConstraint(SqlBaseParser.ColumnIndexConstraintContext context) {
        return new IndexColumnConstraint<Expression>(this.getIdentText(context.method), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitIndexDefinition(SqlBaseParser.IndexDefinitionContext context) {
        return new IndexDefinition<Expression>(this.getIdentText(context.name), this.getIdentText(context.method), this.visitCollection(context.columns().primaryExpression(), Expression.class), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitColumnStorageDefinition(SqlBaseParser.ColumnStorageDefinitionContext ctx) {
        return new ColumnStorageDefinition<Expression>(this.extractGenericProperties(ctx.withProperties()));
    }

    @Override
    public Node visitPartitionedBy(SqlBaseParser.PartitionedByContext context) {
        return new PartitionedBy<Expression>(this.visitCollection(context.columns().primaryExpression(), Expression.class));
    }

    @Override
    public Node visitClusteredBy(SqlBaseParser.ClusteredByContext context) {
        return new ClusteredBy<Expression>(this.visitIfPresent(context.routing, Expression.class), this.visitIfPresent(context.numShards, Expression.class));
    }

    @Override
    public Node visitBlobClusteredInto(SqlBaseParser.BlobClusteredIntoContext ctx) {
        return new ClusteredBy<Expression>(Optional.empty(), this.visitIfPresent(ctx.numShards, Expression.class));
    }

    @Override
    public Node visitFunctionArgument(SqlBaseParser.FunctionArgumentContext context) {
        return new FunctionArgument(this.getIdentText(context.ident()), (ColumnType)this.visit((ParseTree)context.dataType()));
    }

    @Override
    public Node visitRerouteMoveShard(SqlBaseParser.RerouteMoveShardContext context) {
        return new RerouteMoveShard<Node>((Node)this.visit((ParseTree)context.shardId), (Node)this.visit((ParseTree)context.fromNodeId), (Node)this.visit((ParseTree)context.toNodeId));
    }

    @Override
    public Node visitReroutePromoteReplica(SqlBaseParser.ReroutePromoteReplicaContext ctx) {
        return new PromoteReplica<Expression>((Expression)this.visit((ParseTree)ctx.nodeId), (Expression)this.visit((ParseTree)ctx.shardId), this.extractGenericProperties(ctx.withProperties()));
    }

    @Override
    public Node visitRerouteAllocateReplicaShard(SqlBaseParser.RerouteAllocateReplicaShardContext context) {
        return new RerouteAllocateReplicaShard<Node>((Node)this.visit((ParseTree)context.shardId), (Node)this.visit((ParseTree)context.nodeId));
    }

    @Override
    public Node visitRerouteCancelShard(SqlBaseParser.RerouteCancelShardContext context) {
        return new RerouteCancelShard<Expression>((Expression)this.visit((ParseTree)context.shardId), (Expression)this.visit((ParseTree)context.nodeId), this.extractGenericProperties(context.withProperties()));
    }

    private GenericProperties<Expression> extractGenericProperties(ParserRuleContext context) {
        return this.visitIfPresent(context, GenericProperties.class).orElse(GenericProperties.empty());
    }

    @Override
    public Node visitWithGenericProperties(SqlBaseParser.WithGenericPropertiesContext context) {
        return this.visitGenericProperties(context.genericProperties());
    }

    @Override
    public Node visitGenericProperties(SqlBaseParser.GenericPropertiesContext context) {
        List<SqlBaseParser.GenericPropertyContext> genericProperty = context.genericProperty();
        HashMap<String, Expression> properties = HashMap.newHashMap(genericProperty.size());
        for (SqlBaseParser.GenericPropertyContext property : genericProperty) {
            String key = this.getIdentText(property.ident());
            Expression value = (Expression)this.visit((ParseTree)property.expr());
            properties.put(key, value);
        }
        return new GenericProperties(properties);
    }

    @Override
    public Node visitGenericProperty(SqlBaseParser.GenericPropertyContext context) {
        return new GenericProperty<Expression>(this.getIdentText(context.ident()), (Expression)this.visit((ParseTree)context.expr()));
    }

    @Override
    public Node visitAlterTableProperties(SqlBaseParser.AlterTablePropertiesContext context) {
        Table name = (Table)this.visit((ParseTree)context.alterTableDefinition());
        if (context.SET() != null) {
            return new AlterTable<Expression>(name, this.extractGenericProperties(context.genericProperties()));
        }
        return new AlterTable(name, this.identsToStrings(context.ident()));
    }

    @Override
    public Node visitAlterBlobTableProperties(SqlBaseParser.AlterBlobTablePropertiesContext context) {
        Table table = (Table)this.visit((ParseTree)context.alterTableDefinition());
        QualifiedName name = table.getName();
        List<String> parts = name.getParts();
        table = switch (parts.size()) {
            case 1 -> table.withName(new QualifiedName(List.of("blob", parts.getFirst())));
            case 2 -> {
                String schema = parts.get(0);
                if (schema.equalsIgnoreCase("blob")) {
                    yield table;
                }
                throw new IllegalArgumentException("The Schema \"" + schema + "\" isn't valid in a ALTER BLOB TABLE clause");
            }
            default -> throw new IllegalArgumentException("Invalid tableName \"" + String.valueOf(name) + "\"");
        };
        if (context.SET() != null) {
            return new AlterTable<Expression>(table, this.extractGenericProperties(context.genericProperties()));
        }
        return new AlterTable(table, this.identsToStrings(context.ident()));
    }

    @Override
    public Node visitAddColumn(SqlBaseParser.AddColumnContext context) {
        List columnDefinitions = Lists.map(context.addColumnDefinition(), x -> (TableElement)this.visit((ParseTree)x));
        return new AlterTableAddColumn((Table)this.visit((ParseTree)context.alterTableDefinition()), columnDefinitions);
    }

    @Override
    public Node visitAddColumnDefinition(SqlBaseParser.AddColumnDefinitionContext context) {
        return new AddColumnDefinition<Object>(this.visit((ParseTree)context.subscriptSafe()), this.visitOptionalContext(context.dataType(), ColumnType.class), this.visitCollection(context.columnConstraint(), ColumnConstraint.class));
    }

    @Override
    public Node visitDropColumn(SqlBaseParser.DropColumnContext ctx) {
        List columnDefinitions = Lists.map(ctx.dropColumnDefinition(), x -> (TableElement)this.visit((ParseTree)x));
        return new AlterTableDropColumn((Table)this.visit((ParseTree)ctx.alterTableDefinition()), columnDefinitions);
    }

    @Override
    public Node visitDropColumnDefinition(SqlBaseParser.DropColumnDefinitionContext ctx) {
        return new DropColumnDefinition<Object>(this.visit((ParseTree)ctx.subscriptSafe()), ctx.EXISTS() != null);
    }

    @Override
    public Node visitAlterTableOpenClose(SqlBaseParser.AlterTableOpenCloseContext context) {
        return new AlterTableOpenClose((Table)this.visit((ParseTree)context.alterTableDefinition()), context.BLOB() != null, context.OPEN() != null);
    }

    @Override
    public Node visitAlterTableRenameTable(SqlBaseParser.AlterTableRenameTableContext context) {
        return new AlterTableRenameTable((Table)this.visit((ParseTree)context.alterTableDefinition()), context.BLOB() != null, this.getQualifiedName(context.qname()));
    }

    @Override
    public Node visitAlterTableRenameColumn(SqlBaseParser.AlterTableRenameColumnContext ctx) {
        return new AlterTableRenameColumn((Table)this.visit((ParseTree)ctx.alterTableDefinition()), (Expression)this.visit((ParseTree)ctx.source), (Expression)this.visit((ParseTree)ctx.target));
    }

    @Override
    public Node visitAlterTableReroute(SqlBaseParser.AlterTableRerouteContext context) {
        return new AlterTableReroute((Table)this.visit((ParseTree)context.alterTableDefinition()), context.BLOB() != null, (RerouteOption)this.visit((ParseTree)context.rerouteOption()));
    }

    @Override
    public Node visitAlterClusterRerouteRetryFailed(SqlBaseParser.AlterClusterRerouteRetryFailedContext context) {
        return new AlterClusterRerouteRetryFailed();
    }

    @Override
    public Node visitAlterRoleSet(SqlBaseParser.AlterRoleSetContext context) {
        return new AlterRoleSet<Expression>(this.getIdentText(context.name), this.extractGenericProperties(context.genericProperties()));
    }

    @Override
    public Node visitAlterRoleReset(SqlBaseParser.AlterRoleResetContext context) {
        return new AlterRoleReset(this.getIdentText(context.name), context.ALL() == null ? this.getIdentText(context.property) : null);
    }

    @Override
    public Node visitSetGlobalAssignment(SqlBaseParser.SetGlobalAssignmentContext context) {
        return new Assignment<Node>((Node)this.visit((ParseTree)context.primaryExpression()), (Node)this.visit((ParseTree)context.expr()));
    }

    @Override
    public Node visitAssignment(SqlBaseParser.AssignmentContext context) {
        Expression column = (Expression)this.visit((ParseTree)context.primaryExpression());
        if (column instanceof SubscriptExpression || column instanceof QualifiedNameReference) {
            return new Assignment<Expression>(column, (Expression)this.visit((ParseTree)context.expr()));
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "cannot use expression %s as a left side of an assignment", column));
    }

    @Override
    public Node visitQuery(SqlBaseParser.QueryContext context) {
        Query body = (Query)this.visit((ParseTree)context.queryNoWith());
        return new Query(this.visitIfPresent(context.with(), With.class), body.getQueryBody(), body.getOrderBy(), body.getLimit(), body.getOffset());
    }

    @Override
    public Node visitQueryNoWith(SqlBaseParser.QueryNoWithContext context) {
        QueryBody term = (QueryBody)this.visit((ParseTree)context.queryTerm());
        if (term instanceof QuerySpecification) {
            QuerySpecification query = (QuerySpecification)term;
            return new Query(Optional.empty(), new QuerySpecification(query.getSelect(), query.getFrom(), query.getWhere(), query.getGroupBy(), query.getHaving(), query.getWindows(), this.visitCollection(context.sortItem(), SortItem.class), this.visitIfPresent(context.limitClause(), Expression.class), this.visitIfPresent(context.offsetClause(), Expression.class)), List.of(), Optional.empty(), Optional.empty());
        }
        return new Query(Optional.empty(), term, this.visitCollection(context.sortItem(), SortItem.class), this.visitIfPresent(context.limitClause(), Expression.class), this.visitIfPresent(context.offsetClause(), Expression.class));
    }

    @Override
    public Node visitLimitClause(SqlBaseParser.LimitClauseContext ctx) {
        return ctx.limit != null ? (Node)this.visit((ParseTree)ctx.limit) : null;
    }

    @Override
    public Node visitOffsetClause(SqlBaseParser.OffsetClauseContext ctx) {
        return ctx.offset != null ? (Node)this.visit((ParseTree)ctx.offset) : null;
    }

    @Override
    public Node visitIntegerParamOrLiteralDoubleColonCast(SqlBaseParser.IntegerParamOrLiteralDoubleColonCastContext ctx) {
        return new Cast((Expression)this.visit((ParseTree)ctx.parameterOrLiteral()), (ColumnType)this.visit((ParseTree)ctx.dataType()), true);
    }

    @Override
    public Node visitIntegerParamOrLiteralCast(SqlBaseParser.IntegerParamOrLiteralCastContext ctx) {
        return this.generateCast(ctx.TRY_CAST() != null, ctx.expr(), ctx.dataType(), true);
    }

    @Override
    public Node visitDefaultQuerySpec(SqlBaseParser.DefaultQuerySpecContext context) {
        List<SelectItem> selectItems = this.visitCollection(context.selectItem(), SelectItem.class);
        return new QuerySpecification(new Select(AstBuilder.isDistinct(context.setQuant()), selectItems), this.visitCollection(context.relation(), Relation.class), this.visitIfPresent(context.where(), Expression.class), context.ALL() != null ? Optional.of(GroupBy.all()) : (this.visitCollection(context.expr(), Expression.class).isEmpty() ? Optional.empty() : Optional.of(GroupBy.of(this.visitCollection(context.expr(), Expression.class)))), this.visitIfPresent(context.having, Expression.class), this.getWindowDefinitions(context.windows), List.of(), Optional.empty(), Optional.empty());
    }

    @Override
    public Node visitValuesRelation(SqlBaseParser.ValuesRelationContext ctx) {
        return new Values(this.visitCollection(ctx.values(), ValuesList.class));
    }

    private Map<String, Window> getWindowDefinitions(List<SqlBaseParser.NamedWindowContext> windowContexts) {
        HashMap<String, Window> windows = HashMap.newHashMap(windowContexts.size());
        for (SqlBaseParser.NamedWindowContext windowContext : windowContexts) {
            String name = this.getIdentText(windowContext.name);
            if (windows.containsKey(name)) {
                throw new IllegalArgumentException("Window " + name + " is already defined");
            }
            Window window = (Window)this.visit((ParseTree)windowContext.windowDefinition());
            if (window.windowRef() != null && !windows.containsKey(window.windowRef())) {
                throw new IllegalArgumentException("Window " + window.windowRef() + " does not exist");
            }
            windows.put(name, window);
        }
        return windows;
    }

    @Override
    public Node visitWhere(SqlBaseParser.WhereContext context) {
        return (Node)this.visit((ParseTree)context.condition);
    }

    @Override
    public Node visitSortItem(SqlBaseParser.SortItemContext context) {
        return new SortItem((Expression)this.visit((ParseTree)context.expr()), Optional.ofNullable(context.ordering).map(AstBuilder::getOrderingType).orElse(SortItem.Ordering.ASCENDING), Optional.ofNullable(context.nullOrdering).map(AstBuilder::getNullOrderingType).orElse(SortItem.NullOrdering.UNDEFINED));
    }

    @Override
    public Node visitSetOperation(SqlBaseParser.SetOperationContext context) {
        switch (context.operator.getType()) {
            case 202: {
                QueryBody left = (QueryBody)this.visit((ParseTree)context.left);
                QueryBody right = (QueryBody)this.visit((ParseTree)context.right);
                boolean isDistinct = context.setQuant() == null || context.setQuant().ALL() == null;
                return new Union(left, right, isDistinct);
            }
            case 204: {
                QuerySpecification firstIntersect = (QuerySpecification)this.visit((ParseTree)context.first);
                QuerySpecification secondIntersect = (QuerySpecification)this.visit((ParseTree)context.second);
                return new Intersect(firstIntersect, secondIntersect);
            }
            case 203: {
                QuerySpecification firstExcept = (QuerySpecification)this.visit((ParseTree)context.first);
                QuerySpecification secondExcept = (QuerySpecification)this.visit((ParseTree)context.second);
                return new Except(firstExcept, secondExcept);
            }
        }
        throw new IllegalArgumentException("Unsupported set operation: " + context.operator.getText());
    }

    @Override
    public Node visitSelectAll(SqlBaseParser.SelectAllContext context) {
        if (context.qname() != null) {
            return new AllColumns(this.getQualifiedName(context.qname()));
        }
        return new AllColumns();
    }

    @Override
    public Node visitSelectSingle(SqlBaseParser.SelectSingleContext context) {
        return new SingleColumn((Expression)this.visit((ParseTree)context.expr()), this.getIdentText(context.ident()));
    }

    @Override
    public Node visitArraySubquery(SqlBaseParser.ArraySubqueryContext ctx) {
        return new ArraySubQueryExpression((SubqueryExpression)this.visit((ParseTree)ctx.subqueryExpression()));
    }

    @Override
    public Node visitUnquotedIdentifier(SqlBaseParser.UnquotedIdentifierContext context) {
        return new StringLiteral(context.getText().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Node visitQuotedIdentifier(SqlBaseParser.QuotedIdentifierContext context) {
        String token = context.getText();
        String identifier = token.substring(1, token.length() - 1).replace("\"\"", "\"");
        return new StringLiteral(identifier);
    }

    @Nullable
    private String getIdentText(@Nullable SqlBaseParser.IdentContext ident) {
        if (ident != null) {
            StringLiteral literal = (StringLiteral)ident.accept(this);
            return literal.getValue();
        }
        return null;
    }

    public Map<String, Expression> getOptions(@Nullable SqlBaseParser.KvOptionsContext ctx) {
        if (ctx == null) {
            return Map.of();
        }
        HashMap<String, Expression> options = HashMap.newHashMap(ctx.kvOption().size());
        for (SqlBaseParser.KvOptionContext kvOption : ctx.kvOption()) {
            String optionName = this.getIdentText(kvOption.ident());
            Expression value = (Expression)kvOption.parameterOrLiteral().accept(this);
            options.put(optionName, value);
        }
        return options;
    }

    @Override
    public Node visitTableName(SqlBaseParser.TableNameContext ctx) {
        return new Table(this.getQualifiedName(ctx.qname()), false);
    }

    @Override
    public Node visitTableFunction(SqlBaseParser.TableFunctionContext ctx) {
        QualifiedName qualifiedName = this.getQualifiedName(ctx.qname());
        List<Expression> arguments = this.visitCollection(ctx.valueExpression(), Expression.class);
        return new TableFunction(new FunctionCall(qualifiedName, arguments));
    }

    @Override
    public Node visitLogicalNot(SqlBaseParser.LogicalNotContext context) {
        return new NotExpression((Expression)this.visit((ParseTree)context.booleanExpression()));
    }

    @Override
    public Node visitLogicalBinary(SqlBaseParser.LogicalBinaryContext context) {
        return new LogicalBinaryExpression(AstBuilder.getLogicalBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitJoinRelation(SqlBaseParser.JoinRelationContext context) {
        JoinCriteria criteria;
        Relation right;
        Relation left = (Relation)this.visit((ParseTree)context.left);
        if (context.CROSS() != null) {
            Relation right2 = (Relation)this.visit((ParseTree)context.right);
            return new Join(JoinType.CROSS, left, right2, Optional.empty());
        }
        if (context.NATURAL() != null) {
            right = (Relation)this.visit((ParseTree)context.right);
            criteria = new NaturalJoin();
        } else {
            right = (Relation)this.visit((ParseTree)context.rightRelation);
            if (context.joinCriteria().ON() != null) {
                criteria = new JoinOn((Expression)this.visit((ParseTree)context.joinCriteria().booleanExpression()));
            } else if (context.joinCriteria().USING() != null) {
                List<String> columns = this.identsToStrings(context.joinCriteria().ident());
                criteria = new JoinUsing(columns);
            } else {
                throw new IllegalArgumentException("Unsupported join criteria");
            }
        }
        return new Join(AstBuilder.getJoinType(context.joinType()), left, right, Optional.of(criteria));
    }

    private static JoinType getJoinType(SqlBaseParser.JoinTypeContext joinTypeContext) {
        JoinType joinType = joinTypeContext.LEFT() != null ? JoinType.LEFT : (joinTypeContext.RIGHT() != null ? JoinType.RIGHT : (joinTypeContext.FULL() != null ? JoinType.FULL : JoinType.INNER));
        return joinType;
    }

    @Override
    public Node visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.relationPrimary());
        if (context.ident() == null) {
            return child;
        }
        return new AliasedRelation(child, this.getIdentText(context.ident()), this.getColumnAliases(context.aliasedColumns()));
    }

    @Override
    public Node visitSubqueryRelation(SqlBaseParser.SubqueryRelationContext context) {
        return new TableSubquery((Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitParenthesizedRelation(SqlBaseParser.ParenthesizedRelationContext context) {
        return (Node)this.visit((ParseTree)context.relation());
    }

    @Override
    public Node visitPredicated(SqlBaseParser.PredicatedContext context) {
        if (context.predicate() != null) {
            return (Node)this.visit((ParseTree)context.predicate());
        }
        return (Node)this.visit((ParseTree)context.valueExpression);
    }

    @Override
    public Node visitComparison(SqlBaseParser.ComparisonContext context) {
        return new ComparisonExpression(AstBuilder.getComparisonOperator(((TerminalNode)context.cmpOp().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitDistinctFrom(SqlBaseParser.DistinctFromContext context) {
        Expression expression = new ComparisonExpression(ComparisonExpression.Type.IS_DISTINCT_FROM, (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
        if (context.NOT() != null) {
            expression = new NotExpression(expression);
        }
        return expression;
    }

    @Override
    public Node visitBetween(SqlBaseParser.BetweenContext context) {
        Expression expression = new BetweenPredicate((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.lower), (Expression)this.visit((ParseTree)context.upper));
        if (context.NOT() != null) {
            expression = new NotExpression(expression);
        }
        return expression;
    }

    @Override
    public Node visitNullPredicate(SqlBaseParser.NullPredicateContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.value);
        if (context.NOT() == null) {
            return new IsNullPredicate(child);
        }
        return new IsNotNullPredicate(child);
    }

    @Override
    public Node visitLike(SqlBaseParser.LikeContext context) {
        Expression escape = null;
        if (context.escape != null) {
            escape = (Expression)this.visit((ParseTree)context.escape);
        }
        boolean ignoreCase = context.LIKE() == null && context.ILIKE() != null;
        Expression result = new LikePredicate((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.pattern), escape, ignoreCase);
        if (context.NOT() != null) {
            result = new NotExpression(result);
        }
        return result;
    }

    @Override
    public Node visitArrayLike(SqlBaseParser.ArrayLikeContext context) {
        boolean inverse = context.NOT() != null;
        boolean ignoreCase = context.LIKE() == null && context.ILIKE() != null;
        return new ArrayLikePredicate(AstBuilder.getComparisonQuantifier(((TerminalNode)context.setCmpQuantifier().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.v), this.visitOptionalContext(context.escape, Expression.class), inverse, ignoreCase);
    }

    @Override
    public Node visitInList(SqlBaseParser.InListContext context) {
        Expression result = new InPredicate((Expression)this.visit((ParseTree)context.value), new InListExpression(this.visitCollection(context.expr(), Expression.class)));
        if (context.NOT() != null) {
            result = new NotExpression(result);
        }
        return result;
    }

    @Override
    public Node visitInSubquery(SqlBaseParser.InSubqueryContext context) {
        Expression result = new InPredicate((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.subqueryExpression()));
        if (context.NOT() != null) {
            result = new NotExpression(result);
        }
        return result;
    }

    @Override
    public Node visitExists(SqlBaseParser.ExistsContext context) {
        return new ExistsPredicate((Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitQuantifiedComparison(SqlBaseParser.QuantifiedComparisonContext context) {
        return new ArrayComparisonExpression(AstBuilder.getComparisonOperator(((TerminalNode)context.cmpOp().getChild(0)).getSymbol()), AstBuilder.getComparisonQuantifier(((TerminalNode)context.setCmpQuantifier().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.primaryExpression()));
    }

    @Override
    public Node visitMatch(SqlBaseParser.MatchContext context) {
        SqlBaseParser.MatchPredicateIdentsContext predicateIdents = context.matchPredicateIdents();
        List<MatchPredicateColumnIdent> idents = predicateIdents.matchPred != null ? List.of((MatchPredicateColumnIdent)this.visit((ParseTree)predicateIdents.matchPred)) : this.visitCollection(predicateIdents.matchPredicateIdent(), MatchPredicateColumnIdent.class);
        return new MatchPredicate(idents, (Expression)this.visit((ParseTree)context.term), this.getIdentText(context.matchType), this.extractGenericProperties(context.withProperties()));
    }

    @Override
    public Node visitMatchPredicateIdent(SqlBaseParser.MatchPredicateIdentContext context) {
        return new MatchPredicateColumnIdent((Expression)this.visit((ParseTree)context.subscriptSafe()), this.visitOptionalContext(context.boost, Expression.class));
    }

    @Override
    public Node visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext context) {
        return switch (context.operator.getType()) {
            case 297 -> new NegativeExpression((Expression)this.visit((ParseTree)context.valueExpression()));
            case 296 -> (Node)this.visit((ParseTree)context.valueExpression());
            default -> throw new UnsupportedOperationException("Unsupported sign: " + context.operator.getText());
        };
    }

    @Override
    public Node visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext context) {
        return new ArithmeticExpression(AstBuilder.getArithmeticBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitBitwiseBinary(SqlBaseParser.BitwiseBinaryContext context) {
        return new BitwiseExpression(AstBuilder.getBitwiseOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitConcatenation(SqlBaseParser.ConcatenationContext context) {
        return new FunctionCall(QualifiedName.of("op_||", new String[0]), List.of((Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right)));
    }

    @Override
    public Node visitOver(SqlBaseParser.OverContext context) {
        return (Node)this.visit((ParseTree)context.windowDefinition());
    }

    @Override
    public Node visitWindowDefinition(SqlBaseParser.WindowDefinitionContext context) {
        return new Window(this.getIdentText(context.windowRef), this.visitCollection(context.partition, Expression.class), this.visitCollection(context.sortItem(), SortItem.class), this.visitIfPresent(context.windowFrame(), WindowFrame.class));
    }

    @Override
    public Node visitWindowFrame(SqlBaseParser.WindowFrameContext ctx) {
        return new WindowFrame(AstBuilder.getFrameType(ctx.frameType), (FrameBound)this.visit((ParseTree)ctx.start), this.visitIfPresent(ctx.end, FrameBound.class));
    }

    @Override
    public Node visitUnboundedFrame(SqlBaseParser.UnboundedFrameContext context) {
        return new FrameBound(AstBuilder.getUnboundedFrameBoundType(context.boundType));
    }

    @Override
    public Node visitBoundedFrame(SqlBaseParser.BoundedFrameContext context) {
        return new FrameBound(AstBuilder.getBoundedFrameBoundType(context.boundType), (Expression)this.visit((ParseTree)context.expr()));
    }

    @Override
    public Node visitCurrentRowBound(SqlBaseParser.CurrentRowBoundContext context) {
        return new FrameBound(FrameBound.Type.CURRENT_ROW);
    }

    @Override
    public Node visitDoubleColonCast(SqlBaseParser.DoubleColonCastContext context) {
        return new Cast((Expression)this.visit((ParseTree)context.primaryExpression()), (ColumnType)this.visit((ParseTree)context.dataType()));
    }

    @Override
    public Node visitFromStringLiteralCast(SqlBaseParser.FromStringLiteralCastContext context) {
        ColumnType targetType = (ColumnType)this.visit((ParseTree)context.dataType());
        if (targetType instanceof CollectionColumnType || targetType instanceof ObjectColumnType) {
            throw new UnsupportedOperationException("type 'string' cast notation only supports primitive types. Use '::' or cast() operator instead.");
        }
        return new Cast((Expression)this.visit((ParseTree)context.stringLiteral()), targetType);
    }

    @Override
    public Node visitCast(SqlBaseParser.CastContext context) {
        return this.generateCast(context.TRY_CAST() != null, context.expr(), context.dataType(), false);
    }

    @Override
    public Node visitSpecialDateTimeFunction(SqlBaseParser.SpecialDateTimeFunctionContext context) {
        CurrentTime.Type type = AstBuilder.getDateTimeFunctionType(context.name);
        if (context.precision != null) {
            return new CurrentTime(type, Integer.parseInt(context.precision.getText()));
        }
        return new CurrentTime(type);
    }

    @Override
    public Node visitExtract(SqlBaseParser.ExtractContext context) {
        return new Extract((Expression)this.visit((ParseTree)context.expr()), (StringLiteral)this.visit((ParseTree)context.stringLiteralOrIdentifier()));
    }

    @Override
    public Node visitSubstring(SqlBaseParser.SubstringContext context) {
        return new FunctionCall(QualifiedName.of("substring", new String[0]), this.visitCollection(context.expr(), Expression.class));
    }

    @Override
    public Node visitPosition(SqlBaseParser.PositionContext context) {
        Expression substr = (Expression)this.visit((ParseTree)context.expr(0));
        Expression str = (Expression)this.visit((ParseTree)context.expr(1));
        return new FunctionCall(QualifiedName.of("strpos", new String[0]), List.of(str, substr));
    }

    @Override
    public Node visitAtTimezone(SqlBaseParser.AtTimezoneContext context) {
        Expression zone = (Expression)this.visit((ParseTree)context.zone);
        Expression timestamp = (Expression)this.visit((ParseTree)context.timestamp);
        return new FunctionCall(QualifiedName.of("timezone", new String[0]), List.of(zone, timestamp));
    }

    @Override
    public Node visitLeft(SqlBaseParser.LeftContext context) {
        Expression strOrColName = (Expression)this.visit((ParseTree)context.strOrColName);
        Expression len = (Expression)this.visit((ParseTree)context.len);
        return new FunctionCall(QualifiedName.of("left", new String[0]), List.of(strOrColName, len));
    }

    @Override
    public Node visitRight(SqlBaseParser.RightContext context) {
        Expression strOrColName = (Expression)this.visit((ParseTree)context.strOrColName);
        Expression len = (Expression)this.visit((ParseTree)context.len);
        return new FunctionCall(QualifiedName.of("right", new String[0]), List.of(strOrColName, len));
    }

    @Override
    public Node visitTrim(SqlBaseParser.TrimContext ctx) {
        Expression target = (Expression)this.visit((ParseTree)ctx.target);
        if (ctx.charsToTrim == null && ctx.trimMode == null) {
            return new FunctionCall(QualifiedName.of("trim", new String[0]), List.of(target));
        }
        Expression charsToTrim = this.visitIfPresent(ctx.charsToTrim, Expression.class).orElse(new StringLiteral(" "));
        StringLiteral trimMode = new StringLiteral(this.getTrimMode(ctx.trimMode).value());
        return new FunctionCall(QualifiedName.of("trim", new String[0]), List.of(target, charsToTrim, trimMode));
    }

    @Override
    public Node visitCurrentSchema(SqlBaseParser.CurrentSchemaContext context) {
        return new FunctionCall(QualifiedName.of("current_schema", new String[0]), List.of());
    }

    @Override
    public Node visitCurrentUser(SqlBaseParser.CurrentUserContext ctx) {
        return new FunctionCall(QualifiedName.of("current_user", new String[0]), List.of());
    }

    @Override
    public Node visitSessionUser(SqlBaseParser.SessionUserContext ctx) {
        return new FunctionCall(QualifiedName.of("session_user", new String[0]), List.of());
    }

    @Override
    public Node visitNestedExpression(SqlBaseParser.NestedExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expr());
    }

    @Override
    public Node visitSubqueryExpression(SqlBaseParser.SubqueryExpressionContext context) {
        return new SubqueryExpression((Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitArraySlice(SqlBaseParser.ArraySliceContext ctx) {
        return new ArraySliceExpression((Expression)this.visit((ParseTree)ctx.base), this.visitIfPresent(ctx.from, Expression.class), this.visitIfPresent(ctx.to, Expression.class));
    }

    @Override
    public Node visitDereference(SqlBaseParser.DereferenceContext context) {
        return new QualifiedNameReference(QualifiedName.of(this.identsToStrings(context.ident())));
    }

    @Override
    public Node visitRecordSubscript(SqlBaseParser.RecordSubscriptContext ctx) {
        return new RecordSubscript((Expression)this.visit((ParseTree)ctx.base), this.getIdentText(ctx.fieldName));
    }

    @Override
    public Node visitColumnReference(SqlBaseParser.ColumnReferenceContext context) {
        return new QualifiedNameReference(QualifiedName.of(this.getIdentText(context.ident()), new String[0]));
    }

    @Override
    public Node visitSubscript(SqlBaseParser.SubscriptContext context) {
        return new SubscriptExpression((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
    }

    @Override
    public Node visitSubscriptSafe(SqlBaseParser.SubscriptSafeContext context) {
        if (context.qname() != null) {
            return new QualifiedNameReference(this.getQualifiedName(context.qname()));
        }
        return new SubscriptExpression((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
    }

    @Override
    public Node visitQname(SqlBaseParser.QnameContext context) {
        return new QualifiedNameReference(this.getQualifiedName(context));
    }

    @Override
    public Node visitSimpleCase(SqlBaseParser.SimpleCaseContext context) {
        return new SimpleCaseExpression((Expression)this.visit((ParseTree)context.operand), this.visitCollection(context.whenClause(), WhenClause.class), this.visitOptionalContext(context.elseExpr, Expression.class));
    }

    @Override
    public Node visitSearchedCase(SqlBaseParser.SearchedCaseContext context) {
        return new SearchedCaseExpression(this.visitCollection(context.whenClause(), WhenClause.class), this.visitOptionalContext(context.elseExpr, Expression.class));
    }

    @Override
    public Node visitIfCase(SqlBaseParser.IfCaseContext context) {
        return new IfExpression((Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.trueValue), this.visitIfPresent(context.falseValue, Expression.class));
    }

    @Override
    public Node visitWhenClause(SqlBaseParser.WhenClauseContext context) {
        return new WhenClause((Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.result));
    }

    @Override
    public Node visitFilter(SqlBaseParser.FilterContext context) {
        return (Node)this.visit((ParseTree)context.where());
    }

    @Override
    public Node visitFunctionCall(SqlBaseParser.FunctionCallContext context) {
        return new FunctionCall(this.getQualifiedName(context.qname()), AstBuilder.isDistinct(context.setQuant()), this.visitCollection(context.expr(), Expression.class), this.visitIfPresent(context.over(), Window.class), this.visitIfPresent(context.filter(), Expression.class), context.IGNORE() == null && context.RESPECT() == null ? null : Boolean.valueOf(context.IGNORE() != null));
    }

    @Override
    public Node visitNullLiteral(SqlBaseParser.NullLiteralContext context) {
        return NullLiteral.INSTANCE;
    }

    @Override
    public Node visitBitString(SqlBaseParser.BitStringContext ctx) {
        String text = ctx.BIT_STRING().getText();
        return BitString.ofBitString(text);
    }

    @Override
    public Node visitStringLiteral(SqlBaseParser.StringLiteralContext context) {
        if (context.STRING() != null) {
            String text = AstBuilder.unquote(context.STRING().getText());
            if (this.parseStringLiteral != null) {
                try {
                    return this.parseStringLiteral.apply(text);
                }
                catch (Exception e) {
                    return new StringLiteral(text);
                }
            }
            return new StringLiteral(text);
        }
        return this.visitDollarQuotedStringLiteral(context.dollarQuotedStringLiteral());
    }

    @Override
    public Node visitDollarQuotedStringLiteral(SqlBaseParser.DollarQuotedStringLiteralContext ctx) {
        return new StringLiteral(ctx.DOLLAR_QUOTED_STRING_BODY().stream().map(ParseTree::getText).collect(Collectors.joining()));
    }

    @Override
    public Node visitEscapedCharsStringLiteral(SqlBaseParser.EscapedCharsStringLiteralContext ctx) {
        return new EscapedCharStringLiteral(AstBuilder.unquoteEscaped(ctx.ESCAPED_STRING().getText()));
    }

    @Override
    public Node visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext context) {
        String text = context.getText().replace("_", "");
        BigInteger bigInteger = new BigInteger(text);
        int bitLength = bigInteger.bitLength();
        if (bitLength <= 31) {
            return new IntegerLiteral(bigInteger.intValueExact());
        }
        if (bitLength <= 63) {
            return new LongLiteral(bigInteger.longValueExact());
        }
        return new NumericLiteral(new BigDecimal(bigInteger, 0));
    }

    @Override
    public Node visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext context) {
        String text = context.getText().replace("_", "");
        BigDecimal bigDecimal = new BigDecimal(text);
        if (bigDecimal.precision() <= 18 || bigDecimal.scale() < 0) {
            return new DoubleLiteral(bigDecimal.doubleValue());
        }
        return new NumericLiteral(bigDecimal);
    }

    @Override
    public Node visitBooleanLiteral(SqlBaseParser.BooleanLiteralContext context) {
        return context.TRUE() != null ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL;
    }

    @Override
    public Node visitArrayLiteral(SqlBaseParser.ArrayLiteralContext context) {
        return new ArrayLiteral(this.visitCollection(context.expr(), Expression.class));
    }

    @Override
    public Node visitEmptyArray(SqlBaseParser.EmptyArrayContext ctx) {
        return new ArrayLiteral(List.of());
    }

    @Override
    public Node visitObjectLiteral(SqlBaseParser.ObjectLiteralContext context) {
        LinkedHashMap<String, Expression> expressions = new LinkedHashMap<String, Expression>();
        context.objectKeyValue().forEach(attr -> {
            String key = this.getIdentText(attr.key);
            Expression prevEntry = expressions.put(key, (Expression)this.visit((ParseTree)attr.value));
            if (prevEntry != null) {
                throw new IllegalArgumentException("Object literal cannot contain duplicate keys (`" + key + "`)");
            }
        });
        return new ObjectLiteral(expressions);
    }

    @Override
    public Node visitParameterPlaceholder(SqlBaseParser.ParameterPlaceholderContext context) {
        return new ParameterExpression(this.parameterPosition++);
    }

    @Override
    public Node visitPositionalParameter(SqlBaseParser.PositionalParameterContext context) {
        return new ParameterExpression(Integer.parseInt(context.integerLiteral().getText()));
    }

    @Override
    public Node visitOn(SqlBaseParser.OnContext context) {
        return BooleanLiteral.TRUE_LITERAL;
    }

    @Override
    public Node visitArrayDataType(SqlBaseParser.ArrayDataTypeContext ctx) {
        return new CollectionColumnType((ColumnType)this.visit((ParseTree)ctx.dataType()));
    }

    @Override
    public Node visitObjectTypeDefinition(SqlBaseParser.ObjectTypeDefinitionContext context) {
        return new ObjectColumnType(AstBuilder.getObjectType(context.type), this.visitCollection(context.columnDefinition(), ColumnDefinition.class));
    }

    @Override
    public Node visitMaybeParametrizedDataType(SqlBaseParser.MaybeParametrizedDataTypeContext context) {
        StringLiteral name = (StringLiteral)this.visit((ParseTree)context.baseDataType());
        ArrayList<Integer> parameters = new ArrayList<Integer>(context.integerLiteral().size());
        for (SqlBaseParser.IntegerLiteralContext param : context.integerLiteral()) {
            int val;
            Node literal = (Node)this.visit((ParseTree)param);
            if (literal instanceof LongLiteral) {
                LongLiteral l = (LongLiteral)literal;
                val = Math.toIntExact(l.getValue());
            } else {
                val = ((IntegerLiteral)literal).getValue();
            }
            parameters.add(val);
        }
        return new ColumnType(name.getValue(), parameters);
    }

    @Override
    public Node visitIdentDataType(SqlBaseParser.IdentDataTypeContext context) {
        return Literal.fromObject(this.getIdentText(context.ident()));
    }

    @Override
    public Node visitDefinedDataType(SqlBaseParser.DefinedDataTypeContext context) {
        return Literal.fromObject(context.children.stream().map(c -> c.getText().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" ")));
    }

    @Override
    public Node visitCreateServer(SqlBaseParser.CreateServerContext ctx) {
        String name = this.getIdentText(ctx.name);
        String fdw = this.getIdentText(ctx.fdw);
        return new CreateServer(name, fdw, ctx.EXISTS() != null, this.getOptions(ctx.kvOptions()));
    }

    @Override
    public Node visitAlterServer(SqlBaseParser.AlterServerContext ctx) {
        String name = this.getIdentText(ctx.name);
        ArrayList options = new ArrayList();
        SqlBaseParser.AlterServerOptionsContext optionsContext = ctx.alterServerOptions();
        if (optionsContext != null) {
            for (SqlBaseParser.KvOptionWithOperationContext kvOption : optionsContext.kvOptionWithOperation()) {
                String optionName = this.getIdentText(kvOption.ident());
                AlterServer.Operation operation = AstBuilder.getOptionOperation(kvOption.operation);
                Expression value = kvOption.parameterOrLiteral() == null ? null : (Expression)kvOption.parameterOrLiteral().accept(this);
                options.add(new AlterServer.Option<Expression>(operation, optionName, value));
            }
        }
        return new AlterServer(name, options);
    }

    private static AlterServer.Operation getOptionOperation(Token operation) {
        if (operation == null) {
            return AlterServer.Operation.ADD;
        }
        return switch (operation.getType()) {
            case 111 -> AlterServer.Operation.ADD;
            case 219 -> AlterServer.Operation.SET;
            case 200 -> AlterServer.Operation.DROP;
            default -> throw new UnsupportedOperationException("Unsupported option operation: " + operation.getText());
        };
    }

    @Override
    public Node visitDropServer(SqlBaseParser.DropServerContext ctx) {
        CascadeMode cascadeMode = ctx.CASCADE() == null ? CascadeMode.RESTRICT : CascadeMode.CASCADE;
        List<String> names = this.identsToStrings(ctx.names.ident());
        boolean ifExists = ctx.EXISTS() != null;
        return new DropServer(names, ifExists, cascadeMode);
    }

    @Nullable
    private static ColumnPolicy getObjectType(Token type) {
        if (type == null) {
            return null;
        }
        return switch (type.getType()) {
            case 233 -> ColumnPolicy.DYNAMIC;
            case 234 -> ColumnPolicy.STRICT;
            case 235 -> ColumnPolicy.IGNORED;
            default -> throw new UnsupportedOperationException("Unsupported object type: " + type.getText());
        };
    }

    protected Node aggregateResult(Node aggregate, Node nextResult) {
        if (nextResult == null) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (aggregate == null) {
            return nextResult;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Nullable
    private <T> T visitOptionalContext(@Nullable ParserRuleContext context, Class<T> securable) {
        if (context != null) {
            return securable.cast(this.visit((ParseTree)context));
        }
        return null;
    }

    private <T> Optional<T> visitIfPresent(@Nullable ParserRuleContext context, Class<T> securable) {
        if (context == null) {
            return Optional.empty();
        }
        Node node = (Node)context.accept((ParseTreeVisitor)this);
        if (node == null) {
            return Optional.empty();
        }
        return Optional.of(securable.cast(node));
    }

    private <T> List<T> visitCollection(List<? extends ParserRuleContext> contexts, Class<T> securable) {
        ArrayList<T> result = new ArrayList<T>(contexts.size());
        assert (contexts instanceof RandomAccess) : "Index access must be fast";
        for (int i = 0; i < contexts.size(); ++i) {
            ParserRuleContext parserRuleContext = contexts.get(i);
            T item = securable.cast(parserRuleContext.accept((ParseTreeVisitor)this));
            result.add(item);
        }
        return result;
    }

    private static String unquote(String value) {
        return value.substring(1, value.length() - 1).replace("''", "'");
    }

    private static String unquoteEscaped(String value) {
        return value.substring(2, value.length() - 1);
    }

    private List<SelectItem> getReturningItems(@Nullable SqlBaseParser.ReturningContext context) {
        return context == null ? List.of() : this.visitCollection(context.selectItem(), SelectItem.class);
    }

    private QualifiedName getQualifiedName(SqlBaseParser.QnameContext context) {
        return QualifiedName.of(this.identsToStrings(context.ident()));
    }

    private List<QualifiedName> getQualifiedNames(SqlBaseParser.QnamesContext context) {
        ArrayList<QualifiedName> names = new ArrayList<QualifiedName>(context.qname().size());
        for (SqlBaseParser.QnameContext qnameContext : context.qname()) {
            names.add(this.getQualifiedName(qnameContext));
        }
        return names;
    }

    private List<String> identsToStrings(List<SqlBaseParser.IdentContext> idents) {
        return Lists.map(idents, this::getIdentText);
    }

    private static boolean isDistinct(SqlBaseParser.SetQuantContext setQuantifier) {
        return setQuantifier != null && setQuantifier.DISTINCT() != null;
    }

    @Nullable
    private static String getUnquotedText(@Nullable ParserRuleContext context) {
        return context != null ? AstBuilder.unquote(context.getText()) : null;
    }

    private List<String> getColumnAliases(SqlBaseParser.AliasedColumnsContext columnAliasesContext) {
        if (columnAliasesContext == null) {
            return List.of();
        }
        return this.identsToStrings(columnAliasesContext.ident());
    }

    private static ArithmeticExpression.Type getArithmeticBinaryOperator(Token operator) {
        return switch (operator.getType()) {
            case 296 -> ArithmeticExpression.Type.ADD;
            case 297 -> ArithmeticExpression.Type.SUBTRACT;
            case 298 -> ArithmeticExpression.Type.MULTIPLY;
            case 300 -> ArithmeticExpression.Type.DIVIDE;
            case 301 -> ArithmeticExpression.Type.MODULUS;
            case 299 -> ArithmeticExpression.Type.POWER;
            default -> throw new UnsupportedOperationException(UNSUPPORTED_OP_STR + operator.getText());
        };
    }

    private TrimMode getTrimMode(Token type) {
        if (type == null) {
            return TrimMode.BOTH;
        }
        return switch (type.getType()) {
            case 47 -> TrimMode.BOTH;
            case 45 -> TrimMode.LEADING;
            case 46 -> TrimMode.TRAILING;
            default -> throw new UnsupportedOperationException("Unsupported trim mode: " + type.getText());
        };
    }

    private static ComparisonExpression.Type getComparisonOperator(Token symbol) {
        return switch (symbol.getType()) {
            case 285 -> ComparisonExpression.Type.EQUAL;
            case 286 -> ComparisonExpression.Type.NOT_EQUAL;
            case 287 -> ComparisonExpression.Type.LESS_THAN;
            case 288 -> ComparisonExpression.Type.LESS_THAN_OR_EQUAL;
            case 289 -> ComparisonExpression.Type.GREATER_THAN;
            case 290 -> ComparisonExpression.Type.GREATER_THAN_OR_EQUAL;
            case 291 -> ComparisonExpression.Type.CONTAINED_WITHIN;
            case 12 -> ComparisonExpression.Type.IS_DISTINCT_FROM;
            case 292 -> ComparisonExpression.Type.REGEX_MATCH;
            case 293 -> ComparisonExpression.Type.REGEX_NO_MATCH;
            case 294 -> ComparisonExpression.Type.REGEX_MATCH_CI;
            case 295 -> ComparisonExpression.Type.REGEX_NO_MATCH_CI;
            default -> throw new UnsupportedOperationException(UNSUPPORTED_OP_STR + symbol.getText());
        };
    }

    private static CurrentTime.Type getDateTimeFunctionType(Token token) {
        return switch (token.getType()) {
            case 58 -> CurrentTime.Type.DATE;
            case 59 -> CurrentTime.Type.TIME;
            case 60 -> CurrentTime.Type.TIMESTAMP;
            default -> throw new UnsupportedOperationException("Unsupported special function: " + token.getText());
        };
    }

    private static LogicalBinaryExpression.Type getLogicalBinaryOperator(Token token) {
        return switch (token.getType()) {
            case 21 -> LogicalBinaryExpression.Type.AND;
            case 20 -> LogicalBinaryExpression.Type.OR;
            default -> throw new IllegalArgumentException(UNSUPPORTED_OP_STR + token.getText());
        };
    }

    private static BitwiseExpression.Type getBitwiseOperator(Token token) {
        return switch (token.getType()) {
            case 317 -> BitwiseExpression.Type.AND;
            case 318 -> BitwiseExpression.Type.OR;
            case 319 -> BitwiseExpression.Type.XOR;
            default -> throw new IllegalArgumentException(UNSUPPORTED_OP_STR + token.getText());
        };
    }

    private static SortItem.NullOrdering getNullOrderingType(Token token) {
        return switch (token.getType()) {
            case 36 -> SortItem.NullOrdering.FIRST;
            case 37 -> SortItem.NullOrdering.LAST;
            default -> throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
        };
    }

    private static SortItem.Ordering getOrderingType(Token token) {
        return switch (token.getType()) {
            case 40 -> SortItem.Ordering.ASCENDING;
            case 41 -> SortItem.Ordering.DESCENDING;
            default -> throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
        };
    }

    private static String getSecurable(Token token) {
        return switch (token.getType()) {
            case 255 -> SCHEMA;
            case 99 -> TABLE;
            case 196 -> VIEW;
            default -> throw new IllegalArgumentException("Unsupported privilege securable: " + token.getText());
        };
    }

    private static ArrayComparison.Quantifier getComparisonQuantifier(Token symbol) {
        return switch (symbol.getType()) {
            case 7 -> ArrayComparison.Quantifier.ALL;
            case 8 -> ArrayComparison.Quantifier.ANY;
            case 9 -> ArrayComparison.Quantifier.ANY;
            default -> throw new IllegalArgumentException("Unsupported quantifier: " + symbol.getText());
        };
    }

    private List<QualifiedName> getIdents(List<SqlBaseParser.QnameContext> qnames) {
        return qnames.stream().map(this::getQualifiedName).toList();
    }

    private static void validateFunctionName(QualifiedName functionName) {
        if (functionName.getParts().size() > 2) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The function name is not correct! name [%s] does not conform the [[schema_name .] function_name] format.", functionName));
        }
    }

    private SecurableAndIdent getSecurableAndIdentsForPrivileges(boolean onCluster, SqlBaseParser.SecurableContext securable, SqlBaseParser.QnamesContext qnamesContext) {
        if (onCluster) {
            return new SecurableAndIdent(CLUSTER, Collections.emptyList());
        }
        return new SecurableAndIdent(AstBuilder.getSecurable(securable.getStart()), this.getIdents(qnamesContext.qname()));
    }

    private static WindowFrame.Mode getFrameType(Token type) {
        return switch (type.getType()) {
            case 87 -> WindowFrame.Mode.RANGE;
            case 88 -> WindowFrame.Mode.ROWS;
            default -> throw new IllegalArgumentException("Unsupported frame type: " + type.getText());
        };
    }

    private static FrameBound.Type getBoundedFrameBoundType(Token token) {
        return switch (token.getType()) {
            case 90 -> FrameBound.Type.PRECEDING;
            case 91 -> FrameBound.Type.FOLLOWING;
            default -> throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
        };
    }

    private static FrameBound.Type getUnboundedFrameBoundType(Token token) {
        return switch (token.getType()) {
            case 90 -> FrameBound.Type.UNBOUNDED_PRECEDING;
            case 91 -> FrameBound.Type.UNBOUNDED_FOLLOWING;
            default -> throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
        };
    }

    private Expression generateCast(boolean isTryCast, SqlBaseParser.ExprContext expr, SqlBaseParser.DataTypeContext datatype, boolean isIntegerOnly) {
        if (isTryCast) {
            return new TryCast((Expression)this.visit((ParseTree)expr), (ColumnType)this.visit((ParseTree)datatype), isIntegerOnly);
        }
        return new Cast((Expression)this.visit((ParseTree)expr), (ColumnType)this.visit((ParseTree)datatype), isIntegerOnly);
    }

    private static class SecurableAndIdent {
        private final String securable;
        private final List<QualifiedName> idents;

        SecurableAndIdent(String securable, List<QualifiedName> idents) {
            this.securable = securable;
            this.idents = idents;
        }
    }
}

