/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public class AlterPublication
extends Statement {
    private final String name;
    private final Operation operation;
    private final List<QualifiedName> tables;

    public AlterPublication(String name, Operation operation, List<QualifiedName> tables) {
        this.name = name;
        this.operation = operation;
        this.tables = tables;
    }

    public String name() {
        return this.name;
    }

    public Operation operation() {
        return this.operation;
    }

    public List<QualifiedName> tables() {
        return this.tables;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterPublication(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterPublication that = (AlterPublication)o;
        return Objects.equals(this.name, that.name) && this.operation == that.operation && Objects.equals(this.tables, that.tables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.operation, this.tables});
    }

    @Override
    public String toString() {
        return "AlterPublication{name='" + this.name + "', operation=" + String.valueOf((Object)this.operation) + ", tables=" + String.valueOf(this.tables) + "}";
    }

    public static enum Operation {
        ADD,
        SET,
        DROP;

        public static final Operation[] VALUES;

        static {
            VALUES = Operation.values();
        }
    }
}

