/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import java.util.Objects;
import java.util.Optional;

public class ArraySliceExpression
extends Expression {
    private final Expression base;
    private final Optional<Expression> from;
    private final Optional<Expression> to;

    public ArraySliceExpression(Expression base, Optional<Expression> from, Optional<Expression> to) {
        this.base = base;
        this.from = from;
        this.to = to;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitArraySliceExpression(this, context);
    }

    public Expression getBase() {
        return this.base;
    }

    public Optional<Expression> getFrom() {
        return this.from;
    }

    public Optional<Expression> getTo() {
        return this.to;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.from, this.to);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArraySliceExpression other = (ArraySliceExpression)obj;
        return Objects.equals(this.base, other.base) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
    }
}

