/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Node;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class Assignment<T>
extends Node {
    private final T columnName;
    private final List<T> expressions;

    public Assignment(T columnName, List<T> expressions) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.expressions = expressions;
    }

    public Assignment(T columnName, T expression) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.expressions = Collections.singletonList(Objects.requireNonNull(expression, "expression is null"));
    }

    public T columnName() {
        return this.columnName;
    }

    public T expression() {
        return this.expressions.isEmpty() ? null : (T)this.expressions.get(0);
    }

    public List<T> expressions() {
        return this.expressions;
    }

    public <U> Assignment<U> map(Function<? super T, ? extends U> mapper) {
        return new Assignment<List>((List)mapper.apply(this.columnName), Lists.map(this.expressions, mapper));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assignment that = (Assignment)o;
        return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.expressions, that.expressions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columnName, this.expressions);
    }

    @Override
    public String toString() {
        return "Assignment{column=" + String.valueOf(this.columnName) + ", expressions=" + String.valueOf(this.expressions) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAssignment(this, context);
    }
}

