/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.Objects;

public class CopyFrom<T>
extends Statement {
    private final Table<T> table;
    private final List<String> columns;
    private final T path;
    private final GenericProperties<T> properties;
    private final boolean returnSummary;

    public CopyFrom(Table<T> table, List<String> columns, T path, GenericProperties<T> properties, boolean returnSummary) {
        this.table = table;
        this.columns = columns;
        this.path = path;
        this.properties = properties;
        this.returnSummary = returnSummary;
    }

    public Table<T> table() {
        return this.table;
    }

    public List<String> columns() {
        return this.columns;
    }

    public T path() {
        return this.path;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    public boolean isReturnSummary() {
        return this.returnSummary;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyFrom copyFrom = (CopyFrom)o;
        return this.returnSummary == copyFrom.returnSummary && Objects.equals(this.table, copyFrom.table) && Objects.equals(this.columns, copyFrom.columns) && Objects.equals(this.path, copyFrom.path) && Objects.equals(this.properties, copyFrom.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.columns, this.path, this.properties, this.returnSummary);
    }

    @Override
    public String toString() {
        return "CopyFrom{table=" + String.valueOf(this.table) + ", columns=" + String.valueOf(this.columns) + ", path=" + String.valueOf(this.path) + ", properties=" + String.valueOf(this.properties) + ", returnSummary=" + this.returnSummary + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCopyFrom(this, context);
    }
}

