/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class CreateBlobTable<T>
extends Statement {
    private final Table<T> name;
    @Nullable
    private final ClusteredBy<T> clusteredBy;
    private final GenericProperties<T> genericProperties;

    public CreateBlobTable(Table<T> name, Optional<ClusteredBy<T>> clusteredBy, GenericProperties<T> properties) {
        this(name, (ClusteredBy<T>)clusteredBy.orElse(null), properties);
    }

    private CreateBlobTable(Table<T> name, @Nullable ClusteredBy<T> clusteredBy, GenericProperties<T> genericProperties) {
        this.name = name;
        this.clusteredBy = clusteredBy;
        this.genericProperties = genericProperties;
    }

    public Table<T> name() {
        return this.name;
    }

    @Nullable
    public ClusteredBy<T> clusteredBy() {
        return this.clusteredBy;
    }

    public GenericProperties<T> genericProperties() {
        return this.genericProperties;
    }

    public <U> CreateBlobTable<U> map(Function<? super T, ? extends U> mapper) {
        return new CreateBlobTable<U>(this.name.map(mapper), this.clusteredBy == null ? null : this.clusteredBy.map(mapper), this.genericProperties.map(mapper));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateBlobTable that = (CreateBlobTable)o;
        return this.name.equals(that.name) && Objects.equals(this.clusteredBy, that.clusteredBy) && this.genericProperties.equals(that.genericProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.clusteredBy, this.genericProperties);
    }

    @Override
    public String toString() {
        return "CreateBlobTable{name=" + String.valueOf(this.name) + ", clusteredBy=" + String.valueOf(this.clusteredBy) + ", properties=" + String.valueOf(this.genericProperties) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateBlobTable(this, context);
    }
}

