/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.Objects;

public final class CreateTableAs<T>
extends Statement {
    private final Table<T> name;
    private final Query query;
    private final boolean ifNotExists;

    public CreateTableAs(Table<T> name, Query query, boolean ifNotExists) {
        this.name = name;
        this.query = query;
        this.ifNotExists = ifNotExists;
    }

    public Table<T> name() {
        return this.name;
    }

    public Query query() {
        return this.query;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTableAs(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTableAs)) {
            return false;
        }
        CreateTableAs that = (CreateTableAs)o;
        return this.name.equals(that.name) && this.query.equals(that.query) && this.ifNotExists == that.ifNotExists;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.ifNotExists);
    }

    @Override
    public String toString() {
        return "CreateTableAs{name=" + String.valueOf(this.name) + ", query=" + String.valueOf(this.query) + "}";
    }
}

