/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.StringLiteral;
import java.util.Locale;
import java.util.Objects;

public class Extract
extends Expression {
    private final Expression expression;
    private final Field field;

    public Extract(Expression expression, StringLiteral field) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.field = Field.valueOf(field.getValue().toUpperCase(Locale.ENGLISH));
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExtract(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extract extract = (Extract)o;
        return Objects.equals(this.expression, extract.expression) && this.field == extract.field;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.expression, this.field});
    }

    public static enum Field {
        CENTURY,
        YEAR,
        QUARTER,
        MONTH,
        WEEK,
        DAY,
        DAY_OF_MONTH,
        DAY_OF_WEEK,
        DOW,
        DAY_OF_YEAR,
        DOY,
        HOUR,
        MINUTE,
        SECOND,
        TIMEZONE_HOUR,
        TIMEZONE_MINUTE,
        EPOCH;

    }
}

