/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import java.util.Objects;
import java.util.Optional;

public class IfExpression
extends Expression {
    private final Expression condition;
    private final Expression trueValue;
    private final Optional<Expression> falseValue;

    public IfExpression(Expression condition, Expression trueValue, Optional<Expression> falseValue) {
        this.condition = Objects.requireNonNull(condition, "condition is null");
        this.trueValue = Objects.requireNonNull(trueValue, "trueValue is null");
        this.falseValue = falseValue;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getTrueValue() {
        return this.trueValue;
    }

    public Optional<Expression> getFalseValue() {
        return this.falseValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIfExpression(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IfExpression that = (IfExpression)o;
        return Objects.equals(this.condition, that.condition) && Objects.equals(this.trueValue, that.trueValue) && Objects.equals(this.falseValue, that.falseValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.condition, this.trueValue, this.falseValue);
    }
}

