/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.JoinCriteria;
import io.crate.sql.tree.JoinType;
import io.crate.sql.tree.Relation;
import java.util.Objects;
import java.util.Optional;

public class Join
extends Relation {
    private final JoinType type;
    private final Relation left;
    private final Relation right;
    private final Optional<JoinCriteria> criteria;

    public Join(JoinType type, Relation left, Relation right, Optional<JoinCriteria> criteria) {
        if (type.equals((Object)JoinType.CROSS)) {
            if (criteria.isPresent()) {
                throw new IllegalArgumentException("Cross join cannot have join criteria");
            }
        } else if (criteria.isEmpty()) {
            throw new IllegalArgumentException("No join criteria specified");
        }
        this.type = type;
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
        this.criteria = criteria;
    }

    public JoinType getType() {
        return this.type;
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    public Optional<JoinCriteria> getCriteria() {
        return this.criteria;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Join join = (Join)o;
        return this.type == join.type && Objects.equals(this.left, join.left) && Objects.equals(this.right, join.right) && Objects.equals(this.criteria, join.criteria);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.left, this.right, this.criteria});
    }

    @Override
    public String toString() {
        return "Join{type=" + String.valueOf((Object)this.type) + ", left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + ", criteria=" + String.valueOf(this.criteria) + "}";
    }
}

