/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class SetStatement<T>
extends Statement {
    private final Scope scope;
    private final SettingType settingType;
    private final List<Assignment<T>> assignments;

    public SetStatement(Scope scope, List<Assignment<T>> assignments) {
        this(scope, SettingType.TRANSIENT, assignments);
    }

    public SetStatement(Scope scope, SettingType settingType, List<Assignment<T>> assignments) {
        this.scope = scope;
        this.settingType = settingType;
        this.assignments = assignments;
    }

    public SetStatement(Scope scope, Assignment<T> assignment) {
        this.scope = scope;
        this.settingType = SettingType.TRANSIENT;
        this.assignments = Collections.singletonList(assignment);
    }

    public Scope scope() {
        return this.scope;
    }

    public List<Assignment<T>> assignments() {
        return this.assignments;
    }

    public SettingType settingType() {
        return this.settingType;
    }

    public <U> SetStatement<U> map(Function<? super T, ? extends U> mapper) {
        return new SetStatement<T>(this.scope, this.settingType, Lists.map(this.assignments, x -> x.map(mapper)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetStatement that = (SetStatement)o;
        return this.scope == that.scope && this.settingType == that.settingType && Objects.equals(this.assignments, that.assignments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.scope, this.settingType, this.assignments});
    }

    @Override
    public String toString() {
        return "SetStatement{scope=" + String.valueOf((Object)this.scope) + ", assignments=" + String.valueOf(this.assignments) + ", settingType=" + String.valueOf((Object)this.settingType) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetStatement(this, context);
    }

    public static enum SettingType {
        TRANSIENT,
        PERSISTENT;

    }

    public static enum Scope {
        GLOBAL,
        SESSION,
        LOCAL,
        TIME_ZONE;

    }
}

