/*
 * Decompiled with CFR 0.152.
 */
package io.crate.discovery;

import io.crate.common.unit.TimeValue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.SingletonDnsServerAddressStreamProvider;
import io.netty.util.ReferenceCounted;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.transport.TransportService;

@Singleton
public class SrvUnicastHostsProvider
implements AutoCloseable,
SeedHostsProvider {
    private static final Logger LOGGER = LogManager.getLogger(SrvUnicastHostsProvider.class);
    public static final Setting<String> DISCOVERY_SRV_QUERY = Setting.simpleString((String)"discovery.srv.query", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> DISCOVERY_SRV_RESOLVER = Setting.simpleString((String)"discovery.srv.resolver", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<TimeValue> DISCOVERY_SRV_RESOLVE_TIMEOUT = Setting.positiveTimeSetting((String)"discovery.srv.resolve_timeout", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final TransportService transportService;
    private final String query;
    private final TimeValue resolveTimeout;
    private final DnsNameResolver resolver;
    private final EventLoopGroup eventLoopGroup;

    @Inject
    public SrvUnicastHostsProvider(Settings settings, TransportService transportService) {
        this.transportService = transportService;
        this.query = (String)DISCOVERY_SRV_QUERY.get(settings);
        this.resolveTimeout = (TimeValue)DISCOVERY_SRV_RESOLVE_TIMEOUT.get(settings);
        this.eventLoopGroup = new NioEventLoopGroup(1, EsExecutors.daemonThreadFactory((Settings)settings, (String)"netty-dns-resolver"));
        this.resolver = this.buildResolver(settings);
    }

    EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    InetSocketAddress parseResolverAddress(Settings settings) {
        String[] parts;
        int port = 53;
        String resolverAddress = (String)DISCOVERY_SRV_RESOLVER.get(settings);
        if (Strings.hasLength((CharSequence)resolverAddress) && (parts = resolverAddress.split(":")).length > 0) {
            String hostname = parts[0];
            if (parts.length > 1) {
                try {
                    port = Integer.parseInt(parts[1]);
                }
                catch (Exception e) {
                    LOGGER.warn("Resolver port '{}' is not an integer. Using default port 53", (Object)parts[1]);
                }
            }
            try {
                return new InetSocketAddress(hostname, port);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Resolver port '{}' is out of range. Using default port 53", (Object)parts[1]);
                return new InetSocketAddress(hostname, 53);
            }
        }
        return null;
    }

    private DnsNameResolver buildResolver(Settings settings) {
        DnsNameResolverBuilder resolverBuilder = new DnsNameResolverBuilder(this.eventLoopGroup.next());
        resolverBuilder.channelType(NioDatagramChannel.class);
        InetSocketAddress resolverAddress = this.parseResolverAddress(settings);
        if (resolverAddress != null) {
            try {
                resolverBuilder.nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(resolverAddress));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Could not create custom dns resolver. Using default resolver.", (Throwable)e);
            }
        }
        return resolverBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TransportAddress> getSeedAddresses(SeedHostsProvider.HostsResolver hostsResolver) {
        if (this.query == null) {
            LOGGER.error("DNS query must not be null. Please set '{}'", DISCOVERY_SRV_QUERY);
            return Collections.emptyList();
        }
        try {
            List<DnsRecord> records = this.lookupRecords();
            try {
                LOGGER.trace("Building dynamic unicast discovery nodes...");
                if (records == null || records.size() == 0) {
                    LOGGER.debug("No nodes found");
                }
                List<TransportAddress> transportAddresses = this.parseRecords(records);
                LOGGER.info("Using dynamic nodes {}", transportAddresses);
                List<TransportAddress> list = transportAddresses;
                return list;
            }
            finally {
                Iterator<DnsRecord> iterator = records.iterator();
                while (iterator.hasNext()) {
                    DnsRecord record = iterator.next();
                    if (!(record instanceof ReferenceCounted)) continue;
                    ((ReferenceCounted)record).release();
                }
                return Collections.emptyList();
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.error("DNS lookup exception:", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<DnsRecord> lookupRecords() throws InterruptedException, ExecutionException, TimeoutException {
        return (List)this.resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion(this.query, DnsRecordType.SRV), Collections.emptyList()).get(this.resolveTimeout.millis(), TimeUnit.MILLISECONDS);
    }

    List<TransportAddress> parseRecords(List<DnsRecord> records) {
        ArrayList<TransportAddress> addresses = new ArrayList<TransportAddress>(records.size());
        for (DnsRecord record : records) {
            if (!(record instanceof DefaultDnsRawRecord)) continue;
            DefaultDnsRawRecord rawRecord = (DefaultDnsRawRecord)record;
            ByteBuf content = rawRecord.content();
            content.readUnsignedShort();
            content.readUnsignedShort();
            int port = content.readUnsignedShort();
            String hostname = DefaultDnsRecordDecoder.decodeName((ByteBuf)content).replaceFirst("\\.$", "");
            String address = hostname + ":" + port;
            try {
                for (TransportAddress transportAddress : this.transportService.addressesFromString(address)) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("adding {}, transport_address {}", (Object)address, (Object)transportAddress);
                    }
                    addresses.add(transportAddress);
                }
            }
            catch (Exception e) {
                LOGGER.warn("failed to add " + address, (Throwable)e);
            }
        }
        return addresses;
    }

    @Override
    public void close() {
        this.resolver.close();
    }
}

