/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.AbstractProcessor;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.BoundProviderFactory;
import org.elasticsearch.common.inject.ConstantFactory;
import org.elasticsearch.common.inject.ExposedKeyFactory;
import org.elasticsearch.common.inject.FactoryProxy;
import org.elasticsearch.common.inject.Initializable;
import org.elasticsearch.common.inject.Initializer;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.InternalFactoryToProviderAdapter;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.MembersInjector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Scope;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Annotations;
import org.elasticsearch.common.inject.internal.BindingImpl;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.ExposedBindingImpl;
import org.elasticsearch.common.inject.internal.InstanceBindingImpl;
import org.elasticsearch.common.inject.internal.InternalFactory;
import org.elasticsearch.common.inject.internal.LinkedBindingImpl;
import org.elasticsearch.common.inject.internal.LinkedProviderBindingImpl;
import org.elasticsearch.common.inject.internal.ProviderInstanceBindingImpl;
import org.elasticsearch.common.inject.internal.ProviderMethod;
import org.elasticsearch.common.inject.internal.Scoping;
import org.elasticsearch.common.inject.internal.UntargettedBindingImpl;
import org.elasticsearch.common.inject.spi.BindingTargetVisitor;
import org.elasticsearch.common.inject.spi.ConstructorBinding;
import org.elasticsearch.common.inject.spi.ConvertedConstantBinding;
import org.elasticsearch.common.inject.spi.ExposedBinding;
import org.elasticsearch.common.inject.spi.InjectionPoint;
import org.elasticsearch.common.inject.spi.InstanceBinding;
import org.elasticsearch.common.inject.spi.LinkedKeyBinding;
import org.elasticsearch.common.inject.spi.PrivateElements;
import org.elasticsearch.common.inject.spi.ProviderBinding;
import org.elasticsearch.common.inject.spi.ProviderInstanceBinding;
import org.elasticsearch.common.inject.spi.ProviderKeyBinding;
import org.elasticsearch.common.inject.spi.UntargettedBinding;

class BindingProcessor
extends AbstractProcessor {
    private final List<CreationListener> creationListeners = new ArrayList<CreationListener>();
    private final Initializer initializer;
    private final List<Runnable> uninitializedBindings = new ArrayList<Runnable>();
    private static final Set<Class<?>> FORBIDDEN_TYPES = Set.of(AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, Module.class, Provider.class, Scope.class, TypeLiteral.class);

    BindingProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        final Object source = command.getSource();
        if (Void.class.equals(command.getKey().getRawType())) {
            if (command instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command).getProviderInstance() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        final Key<T> key = command.getKey();
        Class<T> rawType = key.getTypeLiteral().getRawType();
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        this.validateKey(command.getSource(), command.getKey());
        final Scoping scoping = Scopes.makeInjectable(((BindingImpl)command).getScoping(), this.injector, this.errors);
        command.acceptTargetVisitor(new BindingTargetVisitor<T, Void>(){
            final /* synthetic */ BindingProcessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visit(InstanceBinding<? extends T> binding) {
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Object instance = binding.getInstance();
                Initializable ref = this.this$0.initializer.requestInjection(this.this$0.injector, instance, source, injectionPoints);
                ConstantFactory factory = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scopes.scope(key, this.this$0.injector, factory, scoping);
                this.this$0.putBinding(new InstanceBindingImpl(this.this$0.injector, key, source, scopedFactory, injectionPoints, instance));
                return null;
            }

            @Override
            public Void visit(ProviderInstanceBinding<? extends T> binding) {
                Provider provider = binding.getProviderInstance();
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Initializable initializable = this.this$0.initializer.requestInjection(this.this$0.injector, provider, source, injectionPoints);
                InternalFactoryToProviderAdapter factory = new InternalFactoryToProviderAdapter(initializable, source);
                InternalFactory scopedFactory = Scopes.scope(key, this.this$0.injector, factory, scoping);
                this.this$0.putBinding(new ProviderInstanceBindingImpl(this.this$0.injector, key, source, scopedFactory, scoping, provider, injectionPoints));
                return null;
            }

            @Override
            public Void visit(ProviderKeyBinding<? extends T> binding) {
                Key providerKey = binding.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(this.this$0.injector, providerKey, source);
                this.this$0.creationListeners.add(boundProviderFactory);
                InternalFactory scopedFactory = Scopes.scope(key, this.this$0.injector, boundProviderFactory, scoping);
                this.this$0.putBinding(new LinkedProviderBindingImpl(this.this$0.injector, key, source, scopedFactory, scoping, providerKey));
                return null;
            }

            @Override
            public Void visit(LinkedKeyBinding<? extends T> binding) {
                Key linkedKey = binding.getLinkedKey();
                if (key.equals(linkedKey)) {
                    this.this$0.errors.recursiveBinding();
                }
                FactoryProxy factory = new FactoryProxy(this.this$0.injector, key, linkedKey, source);
                this.this$0.creationListeners.add(factory);
                InternalFactory scopedFactory = Scopes.scope(key, this.this$0.injector, factory, scoping);
                this.this$0.putBinding(new LinkedBindingImpl(this.this$0.injector, key, source, scopedFactory, scoping, linkedKey));
                return null;
            }

            @Override
            public Void visit(UntargettedBinding<? extends T> untargetted) {
                BindingImpl binding;
                if (key.hasAnnotationType()) {
                    this.this$0.errors.missingImplementation(key);
                    this.this$0.putBinding(this.this$0.invalidBinding(this.this$0.injector, key, source));
                    return null;
                }
                try {
                    binding = this.this$0.injector.createUnitializedBinding(key, scoping, source, this.this$0.errors);
                    this.this$0.putBinding(binding);
                }
                catch (ErrorsException e) {
                    this.this$0.errors.merge(e.getErrors());
                    this.this$0.putBinding(this.this$0.invalidBinding(this.this$0.injector, key, source));
                    return null;
                }
                this.this$0.uninitializedBindings.add(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        try {
                            ((InjectorImpl)binding.getInjector()).initializeBinding(binding, this.this$1.this$0.errors.withSource(this.this$1.source));
                        }
                        catch (ErrorsException e) {
                            this.this$1.this$0.errors.merge(e.getErrors());
                        }
                    }
                });
                return null;
            }

            @Override
            public Void visit(ExposedBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ConvertedConstantBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ConstructorBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Void visit(ProviderBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }
        });
        return true;
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key, privateElements);
        this.creationListeners.add(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>((Injector)this.injector, privateElements.getExposedSource(key), key, exposedKeyFactory, privateElements));
    }

    private <T> void validateKey(Object source, Key<T> key) {
        Annotations.checkForMisplacedScopeAnnotations(key.getRawType(), source, this.errors);
    }

    <T> UntargettedBindingImpl<T> invalidBinding(InjectorImpl injector, Key<T> key, Object source) {
        return new UntargettedBindingImpl<T>(injector, key, source);
    }

    public void initializeBindings() {
        for (Runnable initializer : this.uninitializedBindings) {
            initializer.run();
        }
    }

    public void runCreationListeners() {
        for (CreationListener creationListener : this.creationListeners) {
            creationListener.notify(this.errors);
        }
    }

    private void putBinding(BindingImpl<?> binding) {
        Key<?> key = binding.getKey();
        Class<?> rawType = key.getRawType();
        if (FORBIDDEN_TYPES.contains(rawType)) {
            this.errors.cannotBindToGuiceType(rawType.getSimpleName());
            return;
        }
        BindingImpl<?> original = this.injector.state.getExplicitBinding(key);
        if (original != null && !this.isOkayDuplicate(original, binding)) {
            this.errors.bindingAlreadySet(key, original.getSource());
            return;
        }
        this.injector.state.parent().blacklist(key);
        this.injector.state.putBinding(key, binding);
    }

    private boolean isOkayDuplicate(Binding<?> original, BindingImpl<?> binding) {
        if (original instanceof ExposedBindingImpl) {
            ExposedBindingImpl exposed = (ExposedBindingImpl)original;
            InjectorImpl exposedFrom = (InjectorImpl)exposed.getPrivateElements().getInjector();
            return exposedFrom == binding.getInjector();
        }
        return false;
    }

    static interface CreationListener {
        public void notify(Errors var1);
    }
}

