/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.ItemsByteArrayImpl;
import org.apache.datasketches.quantiles.ItemsMergeImpl;
import org.apache.datasketches.quantiles.ItemsSketchIterator;
import org.apache.datasketches.quantiles.ItemsSketchSortedView;
import org.apache.datasketches.quantiles.ItemsUtil;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantilescommon.GenericPartitionBoundaries;
import org.apache.datasketches.quantilescommon.PartitioningFeature;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericAPI;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;

public final class ItemsSketch<T>
implements QuantilesGenericAPI<T>,
PartitioningFeature<T> {
    final Class<T> clazz;
    private final Comparator<? super T> comparator_;
    final int k_;
    long n_;
    T maxItem_;
    T minItem_;
    int combinedBufferItemCapacity_;
    int baseBufferCount_;
    long bitPattern_;
    Object[] combinedBuffer_;
    ItemsSketchSortedView<T> classicQisSV = null;
    public static final Random rand = new Random();

    private ItemsSketch(int k, Class<T> clazz, Comparator<? super T> comparator) {
        Objects.requireNonNull(clazz, "Class<T> must not be null.");
        Objects.requireNonNull(comparator, "Comparator must not be null.");
        ClassicUtil.checkK(k);
        this.k_ = k;
        this.clazz = clazz;
        this.comparator_ = comparator;
    }

    public static <T> ItemsSketch<T> getInstance(Class<T> clazz, Comparator<? super T> comparator) {
        return ItemsSketch.getInstance(clazz, 128, comparator);
    }

    public static <T> ItemsSketch<T> getInstance(Class<T> clazz, int k, Comparator<? super T> comparator) {
        ItemsSketch<? super T> qs = new ItemsSketch<T>(k, clazz, comparator);
        int bufAlloc = 2 * Math.min(2, k);
        qs.n_ = 0L;
        qs.combinedBufferItemCapacity_ = bufAlloc;
        qs.combinedBuffer_ = new Object[bufAlloc];
        qs.baseBufferCount_ = 0;
        qs.bitPattern_ = 0L;
        qs.minItem_ = null;
        qs.maxItem_ = null;
        return qs;
    }

    public static <T> ItemsSketch<T> getInstance(Class<T> clazz, Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new SketchesArgumentException("Memory too small: " + memCapBytes);
        }
        int preambleLongs = PreambleUtil.extractPreLongs(srcMem);
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        int flags = PreambleUtil.extractFlags(srcMem);
        int k = PreambleUtil.extractK(srcMem);
        ItemsUtil.checkItemsSerVer(serVer);
        if (serVer == 3 && (flags & 8) == 0) {
            throw new SketchesArgumentException("Non-compact Memory images are not supported.");
        }
        boolean empty = ClassicUtil.checkPreLongsFlagsCap(preambleLongs, flags, memCapBytes);
        ClassicUtil.checkFamilyID(familyID);
        ItemsSketch<? super T> sk = ItemsSketch.getInstance(clazz, k, comparator);
        if (empty) {
            return sk;
        }
        long n = PreambleUtil.extractN(srcMem);
        int extra = 2;
        int numMemItems = ClassicUtil.computeRetainedItems(k, n) + 2;
        sk.n_ = n;
        sk.combinedBufferItemCapacity_ = ClassicUtil.computeCombinedBufferItemCapacity(k, n);
        sk.baseBufferCount_ = ClassicUtil.computeBaseBufferItems(k, n);
        sk.bitPattern_ = ClassicUtil.computeBitPattern(k, n);
        sk.combinedBuffer_ = new Object[sk.combinedBufferItemCapacity_];
        int srcMemItemsOffsetBytes = preambleLongs * 8;
        Memory mReg = srcMem.region((long)srcMemItemsOffsetBytes, srcMem.getCapacity() - (long)srcMemItemsOffsetBytes);
        T[] itemsArray = serDe.deserializeFromMemory(mReg, 0L, numMemItems);
        super.itemsArrayToCombinedBuffer(itemsArray);
        return sk;
    }

    static <T> ItemsSketch<T> copy(ItemsSketch<T> sketch) {
        ItemsSketch<? super T> qsCopy = ItemsSketch.getInstance(sketch.clazz, sketch.k_, sketch.comparator_);
        qsCopy.n_ = sketch.n_;
        qsCopy.minItem_ = sketch.isEmpty() ? null : sketch.getMinItem();
        qsCopy.maxItem_ = sketch.isEmpty() ? null : sketch.getMaxItem();
        qsCopy.combinedBufferItemCapacity_ = sketch.getCombinedBufferAllocatedCount();
        qsCopy.baseBufferCount_ = sketch.getBaseBufferCount();
        qsCopy.bitPattern_ = sketch.getBitPattern();
        Object[] combBuf = sketch.getCombinedBuffer();
        qsCopy.combinedBuffer_ = Arrays.copyOf(combBuf, combBuf.length);
        return qsCopy;
    }

    @Override
    public double[] getCDF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getCDF(splitPoints, searchCrit);
    }

    public Class<T> getSketchType() {
        return this.clazz;
    }

    @Override
    public T getMaxItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.maxItem_;
    }

    @Override
    public T getMinItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.minItem_;
    }

    @Override
    public GenericPartitionBoundaries<T> getPartitionBoundaries(int numEquallySized, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getPartitionBoundaries(numEquallySized, searchCrit);
    }

    @Override
    public double[] getPMF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public T getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getQuantile(rank, searchCrit);
    }

    @Override
    public T getQuantileLowerBound(double rank) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.getQuantile(Math.max(0.0, rank - ItemsSketch.getNormalizedRankError(this.k_, false)));
    }

    @Override
    public T getQuantileUpperBound(double rank) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.getQuantile(Math.min(1.0, rank + ItemsSketch.getNormalizedRankError(this.k_, false)));
    }

    @Override
    public T[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getQuantiles(ranks, searchCrit);
    }

    @Override
    public double getRank(T quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQisSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - ItemsSketch.getNormalizedRankError(this.k_, false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + ItemsSketch.getNormalizedRankError(this.k_, false));
    }

    @Override
    public double[] getRanks(T[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.classicQisSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public QuantilesGenericSketchIterator<T> iterator() {
        return new ItemsSketchIterator(this, this.bitPattern_);
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    public double getNormalizedRankError(boolean pmf) {
        return ItemsSketch.getNormalizedRankError(this.k_, pmf);
    }

    public static double getNormalizedRankError(int k, boolean pmf) {
        return ClassicUtil.getNormalizedRankError(k, pmf);
    }

    public static int getKFromEpsilon(double epsilon, boolean pmf) {
        return ClassicUtil.getKFromEpsilon(epsilon, pmf);
    }

    @Override
    public boolean hasMemory() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.getN() == 0L;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isEstimationMode() {
        return this.getN() >= 2L * (long)this.k_;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void reset() {
        this.n_ = 0L;
        this.combinedBufferItemCapacity_ = 2 * Math.min(2, this.k_);
        this.combinedBuffer_ = new Object[this.combinedBufferItemCapacity_];
        this.baseBufferCount_ = 0;
        this.bitPattern_ = 0L;
        this.minItem_ = null;
        this.maxItem_ = null;
        this.classicQisSV = null;
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        return this.toByteArray(false, serDe);
    }

    public byte[] toByteArray(boolean ordered, ArrayOfItemsSerDe<T> serDe) {
        return ItemsByteArrayImpl.toByteArray(this, ordered, serDe);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        return ItemsUtil.toString(sketchSummary, dataDetail, this);
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.toString(byteArr, false);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.toString(mem, false);
    }

    public ItemsSketch<T> downSample(int newK) {
        ItemsSketch<? super T> newSketch = ItemsSketch.getInstance(this.clazz, newK, this.comparator_);
        ItemsMergeImpl.downSamplingMergeInto(this, newSketch);
        return newSketch;
    }

    @Override
    public int getNumRetained() {
        return ClassicUtil.computeRetainedItems(this.getK(), this.getN());
    }

    public void putMemory(WritableMemory dstMem, ArrayOfItemsSerDe<T> serDe) {
        byte[] byteArr = this.toByteArray(serDe);
        long memCap = dstMem.getCapacity();
        if (memCap < (long)byteArr.length) {
            throw new SketchesArgumentException("Destination Memory not large enough: " + memCap + " < " + byteArr.length);
        }
        dstMem.putByteArray(0L, byteArr, 0, byteArr.length);
    }

    @Override
    public ItemsSketchSortedView<T> getSortedView() {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.refreshSortedView();
    }

    @Override
    public void update(T item) {
        if (item == null) {
            return;
        }
        if (this.maxItem_ == null || this.comparator_.compare(item, this.maxItem_) > 0) {
            this.maxItem_ = item;
        }
        if (this.minItem_ == null || this.comparator_.compare(item, this.minItem_) < 0) {
            this.minItem_ = item;
        }
        if (this.baseBufferCount_ + 1 > this.combinedBufferItemCapacity_) {
            ItemsSketch.growBaseBuffer(this);
        }
        this.combinedBuffer_[this.baseBufferCount_++] = item;
        ++this.n_;
        if (this.baseBufferCount_ == 2 * this.k_) {
            ItemsUtil.processFullBaseBuffer(this);
        }
        this.classicQisSV = null;
    }

    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    int getCombinedBufferAllocatedCount() {
        return this.combinedBufferItemCapacity_;
    }

    long getBitPattern() {
        return this.bitPattern_;
    }

    Object[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    Comparator<? super T> getComparator() {
        return this.comparator_;
    }

    private void itemsArrayToCombinedBuffer(T[] itemsArray) {
        long bits;
        int extra = 2;
        this.minItem_ = itemsArray[0];
        this.maxItem_ = itemsArray[1];
        System.arraycopy(itemsArray, 2, this.combinedBuffer_, 0, this.baseBufferCount_);
        if (bits > 0L) {
            int index = 2 + this.baseBufferCount_;
            int level = 0;
            for (bits = this.bitPattern_; bits != 0L; bits >>>= 1) {
                if ((bits & 1L) > 0L) {
                    System.arraycopy(itemsArray, index, this.combinedBuffer_, (2 + level) * this.k_, this.k_);
                    index += this.k_;
                }
                ++level;
            }
        }
    }

    private static <T> void growBaseBuffer(ItemsSketch<T> sketch) {
        int newSize;
        Object[] baseBuffer = sketch.getCombinedBuffer();
        int oldSize = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        assert (oldSize < 2 * k);
        sketch.combinedBufferItemCapacity_ = newSize = Math.max(Math.min(2 * k, 2 * oldSize), 1);
        sketch.combinedBuffer_ = Arrays.copyOf(baseBuffer, newSize);
    }

    private final ItemsSketchSortedView<T> refreshSortedView() {
        if (this.classicQisSV == null) {
            CreateSortedView csv = new CreateSortedView();
            this.classicQisSV = csv.getSV();
        }
        return this.classicQisSV;
    }

    private static long convertToCumulative(long[] array) {
        long subtotal = 0L;
        for (int i = 0; i < array.length; ++i) {
            long newSubtotal;
            subtotal = array[i] = (newSubtotal = subtotal + array[i]);
        }
        return subtotal;
    }

    private final class CreateSortedView {
        final long n;
        final int numQuantiles;
        T[] quantiles;
        long[] cumWeights;
        final int k;
        final T[] combinedBuffer;
        final int baseBufferCount;
        final Comparator<? super T> comparator;

        private CreateSortedView() {
            this.n = ItemsSketch.this.getN();
            this.numQuantiles = ItemsSketch.this.getNumRetained();
            this.quantiles = (Object[])Array.newInstance(ItemsSketch.this.clazz, this.numQuantiles);
            this.cumWeights = new long[this.numQuantiles];
            this.k = ItemsSketch.this.getK();
            this.combinedBuffer = ItemsSketch.this.getCombinedBuffer();
            this.baseBufferCount = ItemsSketch.this.getBaseBufferCount();
            this.comparator = ItemsSketch.this.comparator_;
        }

        ItemsSketchSortedView<T> getSV() {
            long bits;
            long weight = 1L;
            int index = 0;
            assert (bits == this.n / (2L * (long)this.k));
            int lvl = 0;
            for (bits = ItemsSketch.this.getBitPattern(); bits != 0L; bits >>>= 1) {
                weight *= 2L;
                if ((bits & 1L) > 0L) {
                    int offset = (2 + lvl) * this.k;
                    for (int i = 0; i < this.k; ++i) {
                        this.quantiles[index] = this.combinedBuffer[i + offset];
                        this.cumWeights[index] = weight;
                        ++index;
                    }
                }
                ++lvl;
            }
            weight = 1L;
            int startOfBaseBufferBlock = index;
            for (int i = 0; i < this.baseBufferCount; ++i) {
                this.quantiles[index] = this.combinedBuffer[i];
                this.cumWeights[index] = weight;
                ++index;
            }
            assert (index == this.numQuantiles);
            Arrays.sort(this.quantiles, startOfBaseBufferBlock, this.numQuantiles, this.comparator);
            ItemsMergeImpl.blockyTandemMergeSort(this.quantiles, this.cumWeights, this.numQuantiles, this.k, this.comparator);
            if (ItemsSketch.convertToCumulative(this.cumWeights) != this.n) {
                throw new SketchesStateException("Sorted View is misconfigured. TotalN does not match cumWeights.");
            }
            return new ItemsSketchSortedView(this.quantiles, this.cumWeights, ItemsSketch.this.getN(), this.comparator, ItemsSketch.this.getMaxItem(), ItemsSketch.this.getMinItem());
        }
    }
}

