/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.DDLStatement;
import io.crate.expression.symbol.Symbol;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.function.Consumer;

public class AnalyzedCreateSnapshot
implements DDLStatement {
    public static final List<String> ALL_INDICES = List.of("*", "-.blob_*");
    private final String repositoryName;
    private final String snapshotName;
    private final List<Table<Symbol>> tables;
    private final GenericProperties<Symbol> properties;

    AnalyzedCreateSnapshot(String repositoryName, String snapshotName, List<Table<Symbol>> tables, GenericProperties<Symbol> properties) {
        this.repositoryName = repositoryName;
        this.snapshotName = snapshotName;
        this.tables = tables;
        this.properties = properties;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public GenericProperties<Symbol> properties() {
        return this.properties;
    }

    public List<Table<Symbol>> tables() {
        return this.tables;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Table<Symbol> table : this.tables) {
            for (Assignment partitionProperty : table.partitionProperties()) {
                partitionProperty.expressions().forEach(consumer);
            }
        }
        this.properties.forValues(consumer);
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitCreateSnapshotAnalyzedStatement(this, context);
    }
}

