/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.Relations;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.common.collections.Maps;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class AnalyzedInsertStatement
implements AnalyzedStatement {
    private final DocTableInfo targetTable;
    private final AnalyzedRelation subQueryRelation;
    private final boolean ignoreDuplicateKeys;
    private final Map<Reference, Symbol> onDuplicateKeyAssignments;
    private final List<Reference> targetColumns;
    private final List<Symbol> primaryKeySymbols;
    private final List<Symbol> partitionedBySymbols;
    @Nullable
    private final Symbol clusteredBySymbol;
    @Nullable
    private final List<Symbol> returnValues;

    AnalyzedInsertStatement(AnalyzedRelation subQueryRelation, DocTableInfo tableInfo, List<Reference> targetColumns, boolean ignoreDuplicateKeys, Map<Reference, Symbol> onDuplicateKeyAssignments, @Nullable List<Symbol> returnValues) {
        this.targetTable = tableInfo;
        this.subQueryRelation = subQueryRelation;
        this.ignoreDuplicateKeys = ignoreDuplicateKeys;
        this.onDuplicateKeyAssignments = onDuplicateKeyAssignments;
        this.targetColumns = targetColumns;
        Map<ColumnIdent, Integer> columnPositions = AnalyzedInsertStatement.toPositionMap(targetColumns);
        int clusteredByIdx = Objects.requireNonNullElse(columnPositions.get(tableInfo.clusteredBy()), -1);
        this.clusteredBySymbol = clusteredByIdx > -1 ? new InputColumn(clusteredByIdx, targetColumns.get(clusteredByIdx).valueType()) : null;
        Map generatedColumns = Maps.uniqueIndex(tableInfo.generatedColumns(), Reference::column);
        Map defaultExpressionColumns = Maps.uniqueIndex(tableInfo.defaultExpressionColumns(), Reference::column);
        this.primaryKeySymbols = tableInfo.hasAutoGeneratedPrimaryKey() ? Collections.emptyList() : this.symbolsFromTargetColumnPositionOrGeneratedExpression(columnPositions, targetColumns, tableInfo.primaryKey(), generatedColumns, defaultExpressionColumns, true);
        this.partitionedBySymbols = this.symbolsFromTargetColumnPositionOrGeneratedExpression(columnPositions, targetColumns, tableInfo.partitionedBy(), generatedColumns, defaultExpressionColumns, false);
        this.returnValues = returnValues;
    }

    private static Map<ColumnIdent, Integer> toPositionMap(List<Reference> targetColumns) {
        if (targetColumns.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ColumnIdent, Integer> columnPositions = HashMap.newHashMap(targetColumns.size());
        ListIterator<Reference> it = targetColumns.listIterator();
        while (it.hasNext()) {
            columnPositions.put(it.next().column(), it.previousIndex());
        }
        return columnPositions;
    }

    private List<Symbol> symbolsFromTargetColumnPositionOrGeneratedExpression(Map<ColumnIdent, Integer> targetColumnMap, List<Reference> targetColumns, List<ColumnIdent> columns, Map<ColumnIdent, GeneratedReference> generatedColumns, Map<ColumnIdent, Reference> defaultExpressionColumns, boolean alwaysRequireColumn) {
        if (columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Symbol> symbols = new ArrayList<Symbol>(columns.size());
        InputColumns.SourceSymbols sourceSymbols = new InputColumns.SourceSymbols(targetColumns);
        for (ColumnIdent column : columns) {
            Integer position = targetColumnMap.get(column);
            if (position == null) {
                Symbol symbol;
                Reference reference = defaultExpressionColumns.get(column);
                if (reference != null) {
                    symbol = InputColumns.create(Objects.requireNonNull(reference.defaultExpression(), "Column " + String.valueOf(column) + " must contain a default expression"), sourceSymbols);
                } else {
                    GeneratedReference generatedRef = generatedColumns.get(column);
                    if (generatedRef == null) {
                        Reference columnRef = Objects.requireNonNull(this.targetTable.getReference(column), "Column " + String.valueOf(column) + " must exist in table " + String.valueOf(this.targetTable.ident()));
                        symbol = InputColumns.create((Symbol)columnRef, sourceSymbols);
                    } else {
                        symbol = InputColumns.create(generatedRef.generatedExpression(), sourceSymbols);
                    }
                }
                if (symbol.any(Symbol.IS_COLUMN)) {
                    if (alwaysRequireColumn) {
                        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column \"%s\" is required but is missing from the insert statement", column.sqlFqn()));
                    }
                    symbols.add(Literal.NULL);
                    continue;
                }
                symbols.add(symbol);
                continue;
            }
            symbols.add(new InputColumn(position, targetColumns.get(position).valueType()));
        }
        return symbols;
    }

    @Override
    @Nullable
    public List<Symbol> outputs() {
        return this.returnValues;
    }

    public List<Reference> columns() {
        return this.targetColumns;
    }

    public DocTableInfo tableInfo() {
        return this.targetTable;
    }

    public AnalyzedRelation subQueryRelation() {
        return this.subQueryRelation;
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitAnalyzedInsertStatement(this, context);
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        Relations.traverseDeepSymbols(this.subQueryRelation, consumer);
        this.targetColumns.forEach(consumer);
        this.onDuplicateKeyAssignments.values().forEach(consumer);
    }

    @Override
    public boolean isWriteOperation() {
        return true;
    }

    public boolean isIgnoreDuplicateKeys() {
        return this.ignoreDuplicateKeys;
    }

    public Map<Reference, Symbol> onDuplicateKeyAssignments() {
        return this.onDuplicateKeyAssignments;
    }

    public List<Symbol> primaryKeySymbols() {
        return this.primaryKeySymbols;
    }

    public List<Symbol> partitionedBySymbols() {
        return this.partitionedBySymbols;
    }

    @Nullable
    public Symbol clusteredBySymbol() {
        return this.clusteredBySymbol;
    }
}

