/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.DCLStatement;
import io.crate.expression.symbol.Symbol;
import io.crate.role.GrantedRolesChange;
import io.crate.role.Privilege;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class AnalyzedPrivileges
implements DCLStatement {
    private final List<String> userNames;
    private final Set<Privilege> privileges;
    private final GrantedRolesChange grantedRolesChange;

    private AnalyzedPrivileges(List<String> userNames, Set<Privilege> privileges, @Nullable GrantedRolesChange grantedRolesChange) {
        this.userNames = userNames;
        this.privileges = privileges;
        this.grantedRolesChange = grantedRolesChange;
        assert (privileges.isEmpty() && grantedRolesChange != null || grantedRolesChange == null && !privileges.isEmpty()) : "privileges and rolePrivileges cannot be set together";
    }

    public static AnalyzedPrivileges ofPrivileges(List<String> userNames, Set<Privilege> privileges) {
        return new AnalyzedPrivileges(userNames, privileges, null);
    }

    public static AnalyzedPrivileges ofRolePrivileges(List<String> userNames, GrantedRolesChange grantedRolesChange) {
        return new AnalyzedPrivileges(userNames, Set.of(), grantedRolesChange);
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitPrivilegesStatement(this, context);
    }

    public List<String> userNames() {
        return this.userNames;
    }

    public Set<Privilege> privileges() {
        return this.privileges;
    }

    public GrantedRolesChange rolePrivilege() {
        return this.grantedRolesChange;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
    }
}

