/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCopyFrom;
import io.crate.analyze.AnalyzedCopyFromReturnSummary;
import io.crate.analyze.AnalyzedCopyTo;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.NameFieldProvider;
import io.crate.analyze.relations.TableRelation;
import io.crate.common.collections.Lists;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.CopyTo;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.Collection;
import java.util.List;

class CopyAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    CopyAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    AnalyzedCopyFrom analyzeCopyFrom(CopyFrom<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        CoordinatorSessionSettings sessionSettings = txnCtx.sessionSettings();
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation(node.table().getName(), Operation.INSERT, sessionSettings.sessionUser(), sessionSettings.searchPath());
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(sessionSettings);
        ExpressionAnalyzer exprAnalyzerWithoutFields = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(this.nodeCtx, RowGranularity.CLUSTER, null, new TableRelation(tableInfo), f -> f.signature().isDeterministic());
        Table table = node.table().map(t -> exprAnalyzerWithFieldsAsString.convert((Expression)t, exprCtx));
        GenericProperties properties = node.properties().map(t -> exprAnalyzerWithoutFields.convert((Expression)t, exprCtx));
        Symbol uri = exprAnalyzerWithoutFields.convert((Expression)node.path(), exprCtx);
        if (node.isReturnSummary()) {
            return new AnalyzedCopyFromReturnSummary(tableInfo, node.columns(), (Table<Symbol>)table, (GenericProperties<Symbol>)properties, normalizer.normalize(uri, txnCtx));
        }
        return new AnalyzedCopyFrom(tableInfo, node.columns(), (Table<Symbol>)table, (GenericProperties<Symbol>)properties, normalizer.normalize(uri, txnCtx));
    }

    AnalyzedCopyTo analyzeCopyTo(CopyTo<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        if (!node.directoryUri()) {
            throw new UnsupportedOperationException("Using COPY TO without specifying a DIRECTORY is not supported");
        }
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation(node.table().getName(), Operation.COPY_TO, txnCtx.sessionSettings().sessionUser(), txnCtx.sessionSettings().searchPath());
        Operation.blockedRaiseException(tableInfo, Operation.READ);
        DocTableRelation tableRelation = new DocTableRelation(tableInfo);
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(this.nodeCtx, RowGranularity.CLUSTER, null, tableRelation, f -> f.signature().isDeterministic());
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, new NameFieldProvider(tableRelation), null);
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
        Symbol uri = expressionAnalyzer.convert((Expression)node.targetUri(), exprCtx);
        Table table = node.table().map(x -> exprAnalyzerWithFieldsAsString.convert((Expression)x, exprCtx));
        GenericProperties properties = node.properties().map(x -> expressionAnalyzer.convert((Expression)x, exprCtx));
        List columns = Lists.map((Collection)node.columns(), c -> normalizer.normalize(expressionAnalyzer.convert((Expression)c, exprCtx), txnCtx));
        Symbol whereClause = node.whereClause().map(w -> normalizer.normalize(expressionAnalyzer.convert((Expression)w, exprCtx), txnCtx)).orElse(null);
        return new AnalyzedCopyTo(tableInfo, (Table<Symbol>)table, normalizer.normalize(uri, txnCtx), (GenericProperties<Symbol>)properties, columns, whereClause);
    }
}

