/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCreateFunction;
import io.crate.analyze.DataTypeAnalyzer;
import io.crate.analyze.FunctionArgumentDefinition;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.common.collections.Lists;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.SearchPath;
import io.crate.sql.tree.CreateFunction;
import io.crate.sql.tree.Expression;
import io.crate.types.DataType;
import java.util.Collection;
import java.util.List;

public class CreateFunctionAnalyzer {
    private final NodeContext nodeCtx;

    CreateFunctionAnalyzer(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedCreateFunction analyze(CreateFunction<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx, SearchPath searchPath) {
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        DataType<?> returnType = DataTypeAnalyzer.convert(node.returnType());
        Symbol definition = expressionAnalyzer.convert((Expression)node.definition(), exprCtx);
        Symbol language = expressionAnalyzer.convert((Expression)node.language(), exprCtx);
        List parts = node.name().getParts();
        return new AnalyzedCreateFunction(CreateFunctionAnalyzer.resolveSchemaName(parts, searchPath.currentSchema()), CreateFunctionAnalyzer.resolveFunctionName(parts), node.replace(), Lists.map((Collection)node.arguments(), arg -> FunctionArgumentDefinition.of(arg.name(), DataTypeAnalyzer.convert(arg.type()))), returnType, language, definition);
    }

    static String resolveFunctionName(List<String> parts) {
        return parts.size() == 1 ? parts.get(0) : parts.get(1);
    }

    static String resolveSchemaName(List<String> parts, String sessionSchema) {
        return parts.size() == 1 ? sessionSchema : parts.get(0);
    }
}

