/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedAlterTableAddColumn;
import io.crate.analyze.AnalyzedCheck;
import io.crate.analyze.AnalyzedCreateForeignTable;
import io.crate.analyze.AnalyzedCreateTable;
import io.crate.analyze.DataTypeAnalyzer;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.ddl.GeoSettingsApplier;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.common.annotations.NotThreadSafe;
import io.crate.common.collections.Lists;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.ColumnValidationException;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.GeoReference;
import io.crate.metadata.IndexReference;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.planner.operators.EnsureNoMatchPredicate;
import io.crate.sql.tree.AddColumnDefinition;
import io.crate.sql.tree.AlterTableAddColumn;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.CollectionColumnType;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ColumnStorageDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.CreateForeignTable;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.DefaultConstraint;
import io.crate.sql.tree.DefaultTraversalVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GeneratedExpressionConstraint;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.IndexColumnConstraint;
import io.crate.sql.tree.IndexDefinition;
import io.crate.sql.tree.NotNullColumnConstraint;
import io.crate.sql.tree.NullColumnConstraint;
import io.crate.sql.tree.ObjectColumnType;
import io.crate.sql.tree.PartitionedBy;
import io.crate.sql.tree.PrimaryKeyColumnConstraint;
import io.crate.sql.tree.PrimaryKeyConstraint;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.TableElement;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import io.crate.types.StorageSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.UUIDs;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class TableElementsAnalyzer
implements FieldProvider<Reference> {
    public static final Set<Integer> UNSUPPORTED_INDEX_TYPE_IDS = Set.of(Integer.valueOf(12), Integer.valueOf(DataTypes.GEO_POINT.id()), Integer.valueOf(DataTypes.GEO_SHAPE.id()));
    public static final Set<Integer> UNSUPPORTED_PK_TYPE_IDS = Set.of(Integer.valueOf(12), Integer.valueOf(DataTypes.GEO_POINT.id()), Integer.valueOf(DataTypes.GEO_SHAPE.id()));
    public static final String COLUMN_STORE_PROPERTY = "columnstore";
    private final RelationName tableName;
    private final ExpressionAnalyzer expressionAnalyzer;
    private final ExpressionAnalysisContext expressionContext;
    private final Map<ColumnIdent, RefBuilder> columns = new LinkedHashMap<ColumnIdent, RefBuilder>();
    private final PeekColumns peekColumns;
    private final ColumnAnalyzer columnAnalyzer;
    private final Function<Expression, Symbol> toSymbol;
    private final Set<ColumnIdent> primaryKeys = new HashSet<ColumnIdent>();
    private final Map<String, AnalyzedCheck> checks = new LinkedHashMap<String, AnalyzedCheck>();
    @Nullable
    private final DocTableInfo table;
    private boolean resolveMissing = false;
    private final EvaluatingNormalizer normalizer;
    private final CoordinatorTxnCtx txnCtx;

    public TableElementsAnalyzer(RelationName tableName, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints) {
        this(null, tableName, txnCtx, nodeCtx, paramTypeHints);
    }

    public TableElementsAnalyzer(DocTableInfo table, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints) {
        this(table, table.ident(), txnCtx, nodeCtx, paramTypeHints);
    }

    private TableElementsAnalyzer(@Nullable DocTableInfo table, RelationName tableName, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints) {
        this.table = table;
        this.tableName = tableName;
        this.txnCtx = txnCtx;
        this.normalizer = EvaluatingNormalizer.functionOnlyNormalizer(nodeCtx);
        this.expressionAnalyzer = new ExpressionAnalyzer(txnCtx, nodeCtx, paramTypeHints, this, null);
        this.expressionContext = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        this.columnAnalyzer = new ColumnAnalyzer();
        this.peekColumns = new PeekColumns();
        this.toSymbol = x -> this.expressionAnalyzer.convert((Expression)x, this.expressionContext);
    }

    @Override
    public Reference resolveField(QualifiedName qualifiedName, @Nullable List<String> path, Operation operation, boolean errorOnUnknownObjectKey) {
        Reference reference;
        ColumnIdent columnIdent = ColumnIdent.fromNameSafe(qualifiedName, path);
        if (this.table != null && (reference = this.table.getReference(columnIdent)) != null) {
            return reference;
        }
        RefBuilder columnBuilder = this.columns.get(columnIdent);
        DynamicReference dynamicReference = new DynamicReference(new ReferenceIdent(this.tableName, columnIdent), RowGranularity.DOC, -1);
        if (columnBuilder == null) {
            if (this.resolveMissing) {
                return dynamicReference;
            }
            throw new ColumnUnknownException(columnIdent, this.tableName);
        }
        dynamicReference.valueType(columnBuilder.type);
        return dynamicReference;
    }

    public AnalyzedCreateTable analyze(CreateTable<Expression> createTable) {
        for (TableElement tableElement : createTable.tableElements()) {
            tableElement.accept((AstVisitor)this.peekColumns, null);
        }
        for (TableElement tableElement : createTable.tableElements()) {
            tableElement.accept((AstVisitor)this.columnAnalyzer, null);
        }
        GenericProperties properties = createTable.properties().map(this.toSymbol);
        Optional<ClusteredBy<Symbol>> clusteredBy = createTable.clusteredBy().map(x -> x.map(this.toSymbol));
        Function<Expression, Reference> toRef = x -> {
            Symbol symbol = this.toSymbol.apply((Expression)x);
            if (symbol instanceof Reference) {
                Reference ref = (Reference)symbol;
                return ref;
            }
            throw new IllegalArgumentException("Expression must be a column: " + String.valueOf(x));
        };
        Optional<PartitionedBy<Reference>> partitionedBy = createTable.partitionedBy().map(x -> x.map(toRef));
        partitionedBy.ifPresent(p -> p.columns().forEach(partitionColumn -> {
            ColumnIdent partitionColumnIdent = partitionColumn.toColumn();
            RefBuilder column = this.columns.get(partitionColumnIdent);
            if (column == null) {
                throw new ColumnUnknownException(partitionColumnIdent, this.tableName);
            }
            this.ensureValidPartitionColumn(clusteredBy, partitionColumnIdent, column);
            column.indexType = IndexType.NONE;
            column.rowGranularity = RowGranularity.PARTITION;
        }));
        return new AnalyzedCreateTable(this.tableName, createTable.ifNotExists(), this.columns, this.checks, (GenericProperties<Symbol>)properties, partitionedBy, clusteredBy);
    }

    public AnalyzedCreateForeignTable analyze(CreateForeignTable createTable) {
        for (TableElement tableElement : createTable.tableElements()) {
            tableElement.accept((AstVisitor)this.peekColumns, null);
        }
        for (TableElement tableElement : createTable.tableElements()) {
            tableElement.accept((AstVisitor)this.columnAnalyzer, null);
        }
        HashMap<String, Symbol> options = HashMap.newHashMap(createTable.options().size());
        for (Map.Entry entry : createTable.options().entrySet()) {
            String name = (String)entry.getKey();
            Expression value = (Expression)entry.getValue();
            options.put(name, this.expressionAnalyzer.convert(value, this.expressionContext));
        }
        return new AnalyzedCreateForeignTable(this.tableName, createTable.ifNotExists(), this.columns, createTable.server(), options);
    }

    public AnalyzedAlterTableAddColumn analyze(AlterTableAddColumn<Expression> alterTable) {
        assert (this.table != null) : "Must use CTOR that sets the DocTableInfo instance";
        List tableElements = alterTable.tableElements();
        for (AddColumnDefinition addColumnDefinition : tableElements) {
            addColumnDefinition.accept((AstVisitor)this.peekColumns, null);
        }
        for (AddColumnDefinition addColumnDefinition : tableElements) {
            addColumnDefinition.accept((AstVisitor)this.columnAnalyzer, null);
        }
        return new AnalyzedAlterTableAddColumn(this.table, this.columns, this.checks);
    }

    private void ensureValidPartitionColumn(Optional<ClusteredBy<Symbol>> clusteredBy, ColumnIdent partitionColumnIdent, RefBuilder column) {
        if (partitionColumnIdent.isSystemColumn()) {
            throw new IllegalArgumentException("Cannot use system column `" + String.valueOf(partitionColumnIdent) + "` in PARTITIONED BY clause");
        }
        if (!this.primaryKeys.isEmpty() && !this.primaryKeys.contains(partitionColumnIdent)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use non primary key column '%s' in PARTITIONED BY clause if primary key is set on table", partitionColumnIdent.sqlFqn()));
        }
        if (!DataTypes.isPrimitive(column.type)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use column %s of type %s in PARTITIONED BY clause", partitionColumnIdent.sqlFqn(), column.type));
        }
        for (ColumnIdent parent : partitionColumnIdent.parents()) {
            RefBuilder parentColumn = this.columns.get(parent);
            if (!(parentColumn.type instanceof ArrayType)) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use array column %s in PARTITIONED BY clause", partitionColumnIdent.sqlFqn()));
        }
        if (column.indexType == IndexType.FULLTEXT) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use column %s with fulltext index in PARTITIONED BY clause", partitionColumnIdent.sqlFqn()));
        }
        clusteredBy.flatMap(ClusteredBy::column).ifPresent(clusteredBySymbol -> {
            ColumnIdent clusteredByColumnIdent = clusteredBySymbol.toColumn();
            if (partitionColumnIdent.equals(clusteredByColumnIdent)) {
                throw new IllegalArgumentException("Cannot use CLUSTERED BY column `" + String.valueOf(clusteredByColumnIdent) + "` in PARTITIONED BY clause");
            }
        });
    }

    private void addCheck(@Nullable String constraintName, String expression, Symbol expressionSymbol, @Nullable ColumnIdent column) {
        AnalyzedCheck exists;
        if (constraintName == null) {
            while (this.checks.containsKey(constraintName = TableElementsAnalyzer.genUniqueConstraintName(this.tableName, column))) {
            }
        }
        AnalyzedCheck analyzedCheck = new AnalyzedCheck(expression, expressionSymbol, null);
        if (column != null) {
            expressionSymbol.visit(Reference.class, ref -> {
                if (!ref.column().equals(column)) {
                    throw new UnsupportedOperationException("CHECK constraint on column `" + String.valueOf(column) + "` cannot refer to column `" + String.valueOf(ref.column()) + "`. Use full path to refer to a sub-column or a table check constraint instead");
                }
            });
        }
        if ((exists = this.checks.put(constraintName, analyzedCheck)) != null) {
            throw new IllegalArgumentException("a check constraint of the same name is already declared [" + constraintName + "]");
        }
    }

    private static String genUniqueConstraintName(RelationName table, ColumnIdent column) {
        StringBuilder sb = new StringBuilder(table.fqn().replace(".", "_"));
        if (column != null) {
            sb.append("_").append(column.fqn().replace(".", "_"));
        }
        sb.append("_check_");
        String uuid = UUIDs.dirtyUUID().toString();
        int idx = uuid.lastIndexOf("-");
        sb.append(idx > 0 ? uuid.substring(idx + 1) : uuid);
        return sb.toString();
    }

    private void markAsPrimaryKey(RefBuilder column, @Nullable String pkConstraintName) {
        if (column.explicitNullable) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column \"%s\" is declared NULL, therefore, cannot be declared as a PRIMARY KEY", column.name));
        }
        column.pkConstraintName = pkConstraintName;
        column.primaryKey = true;
        column.nullable = false;
        ColumnIdent columnName = column.name;
        DataType<?> type = column.type;
        if (type instanceof ArrayType) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use column \"%s\" with type \"%s\" as primary key", columnName.sqlFqn(), type));
        }
        if (UNSUPPORTED_PK_TYPE_IDS.contains(type.id())) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use columns of type \"%s\" as primary key", type));
        }
        for (ColumnIdent parent : columnName.parents()) {
            RefBuilder parentColumn = this.columns.get(parent);
            if (!(parentColumn.type instanceof ArrayType)) continue;
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot use column \"%s\" as primary key within an array object", columnName.leafName()));
        }
        boolean wasNew = this.primaryKeys.add(column.name);
        if (!wasNew) {
            throw new IllegalArgumentException("Columns `" + String.valueOf(column.name) + "` appears twice in primary key constraint");
        }
    }

    class ColumnAnalyzer
    extends DefaultTraversalVisitor<Void, ColumnIdent> {
        ColumnAnalyzer() {
        }

        public Void visitColumnDefinition(ColumnDefinition<?> node, ColumnIdent parent) {
            ColumnDefinition<?> columnDefinition = node;
            ColumnIdent columnName = parent == null ? ColumnIdent.of(columnDefinition.ident()) : ColumnIdent.getChildSafe(parent, columnDefinition.ident());
            RefBuilder builder = TableElementsAnalyzer.this.columns.get(columnName);
            for (ColumnConstraint constraint : columnDefinition.constraints()) {
                this.processConstraint(builder, (ColumnConstraint<Expression>)constraint);
            }
            ColumnType type = columnDefinition.type();
            while (type instanceof CollectionColumnType) {
                CollectionColumnType collectionColumnType = (CollectionColumnType)type;
                type = collectionColumnType.innerType();
            }
            if (type instanceof ObjectColumnType) {
                ObjectColumnType objectColumnType = (ObjectColumnType)type;
                builder.columnPolicy = objectColumnType.columnPolicy().orElse(ColumnPolicy.DYNAMIC);
                for (ColumnDefinition nestedColumn : objectColumnType.nestedColumns()) {
                    nestedColumn.accept((AstVisitor)this, (Object)columnName);
                }
            }
            return null;
        }

        private void processConstraint(RefBuilder builder, ColumnConstraint<Expression> constraint) {
            ColumnIdent columnName = builder.name;
            if (constraint instanceof CheckColumnConstraint) {
                CheckColumnConstraint checkConstraint = (CheckColumnConstraint)constraint;
                TableElementsAnalyzer.this.resolveMissing = true;
                Symbol checkSymbol = TableElementsAnalyzer.this.expressionAnalyzer.convert((Expression)checkConstraint.expression(), TableElementsAnalyzer.this.expressionContext);
                TableElementsAnalyzer.this.addCheck(checkConstraint.name(), checkConstraint.expressionStr(), checkSymbol, columnName);
                TableElementsAnalyzer.this.resolveMissing = false;
            } else if (constraint instanceof ColumnStorageDefinition) {
                ColumnStorageDefinition storageDefinition = (ColumnStorageDefinition)constraint;
                GenericProperties storageProperties = storageDefinition.properties().map(TableElementsAnalyzer.this.toSymbol);
                for (String storageProperty : storageProperties.keys()) {
                    if (TableElementsAnalyzer.COLUMN_STORE_PROPERTY.equals(storageProperty)) continue;
                    throw new IllegalArgumentException("Invalid STORAGE WITH option `" + storageProperty + "` for column `" + columnName.sqlFqn() + "`");
                }
                builder.storageProperties = storageProperties;
            } else if (constraint instanceof IndexColumnConstraint) {
                IndexColumnConstraint indexConstraint = (IndexColumnConstraint)constraint;
                builder.indexMethod = indexConstraint.indexMethod();
                builder.indexProperties = indexConstraint.properties().map(TableElementsAnalyzer.this.toSymbol);
                builder.indexType = IndexType.of(builder.indexMethod);
                if (builder.indexType == IndexType.FULLTEXT && !DataTypes.STRING.equals(ArrayType.unnest(builder.type))) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Can't use an Analyzer on column %s because analyzers are only allowed on columns of type \"%s\" of the unbound length limit.", columnName.sqlFqn(), DataTypes.STRING.getName()));
                }
                if (builder.indexType != IndexType.PLAIN && UNSUPPORTED_INDEX_TYPE_IDS.contains(builder.type.id())) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "INDEX constraint cannot be used on columns of type \"%s\": `%s`", builder.type, columnName));
                }
            } else if (constraint instanceof NotNullColumnConstraint) {
                builder.nullable = false;
                if (builder.explicitNullable) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column \"%s\" is declared NULL, therefore, cannot be declared NOT NULL", columnName));
                }
            } else if (constraint instanceof PrimaryKeyColumnConstraint) {
                PrimaryKeyColumnConstraint primaryKeyColumnConstraint = (PrimaryKeyColumnConstraint)constraint;
                TableElementsAnalyzer.this.markAsPrimaryKey(builder, primaryKeyColumnConstraint.constraintName());
            } else if (constraint instanceof NullColumnConstraint) {
                builder.explicitNullable = true;
                if (builder.primaryKey) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column \"%s\" is declared as PRIMARY KEY, therefore, cannot be declared NULL", columnName));
                }
                if (!builder.nullable) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column \"%s\" is declared as NOT NULL, therefore, cannot be declared NULL", columnName));
                }
            } else if (constraint instanceof DefaultConstraint) {
                DefaultConstraint defaultConstraint = (DefaultConstraint)constraint;
                Expression defaultExpression = (Expression)defaultConstraint.expression();
                if (defaultExpression != null) {
                    if (builder.type.id() == 12) {
                        throw new IllegalArgumentException("Default values are not allowed for object columns: " + String.valueOf(columnName));
                    }
                    Symbol defaultSymbol = TableElementsAnalyzer.this.expressionAnalyzer.convert(defaultExpression, TableElementsAnalyzer.this.expressionContext);
                    builder.defaultExpression = defaultSymbol.cast(builder.type, CastMode.IMPLICIT);
                    TableElementsAnalyzer.this.normalizer.normalize(builder.defaultExpression, TableElementsAnalyzer.this.txnCtx);
                    builder.defaultExpression.visit(Reference.class, x -> {
                        throw new UnsupportedOperationException("Cannot reference columns in DEFAULT expression of `" + String.valueOf(columnName) + "`. Maybe you wanted to use a string literal with single quotes instead: '" + x.column().name() + "'");
                    });
                    EnsureNoMatchPredicate.ensureNoMatchPredicate(defaultSymbol, "Cannot use MATCH in CREATE TABLE statements");
                }
            } else if (constraint instanceof GeneratedExpressionConstraint) {
                GeneratedExpressionConstraint generatedExpressionConstraint = (GeneratedExpressionConstraint)constraint;
                Expression generatedExpression = (Expression)generatedExpressionConstraint.expression();
                if (generatedExpression != null) {
                    builder.generated = TableElementsAnalyzer.this.expressionAnalyzer.convert(generatedExpression, TableElementsAnalyzer.this.expressionContext);
                    EnsureNoMatchPredicate.ensureNoMatchPredicate(builder.generated, "Cannot use MATCH in CREATE TABLE statements");
                    if (builder.type == DataTypes.UNDEFINED) {
                        builder.type = builder.generated.valueType();
                    } else {
                        builder.generated = builder.generated.cast(builder.type, CastMode.IMPLICIT);
                    }
                    TableElementsAnalyzer.this.normalizer.normalize(builder.generated, TableElementsAnalyzer.this.txnCtx);
                }
            } else {
                throw new UnsupportedOperationException("constraint not supported: " + String.valueOf(constraint));
            }
        }

        public Void visitAddColumnDefinition(AddColumnDefinition<?> node, ColumnIdent parent) {
            assert (parent == null) : "ADD COLUMN doesn't allow parents";
            AddColumnDefinition<?> columnDefinition = node;
            Expression name = (Expression)columnDefinition.name();
            ColumnIdent columnName = TableElementsAnalyzer.this.expressionAnalyzer.convert(name, TableElementsAnalyzer.this.expressionContext).toColumn();
            RefBuilder builder = TableElementsAnalyzer.this.columns.get(columnName);
            for (ColumnConstraint constraint : columnDefinition.constraints()) {
                this.processConstraint(builder, (ColumnConstraint<Expression>)constraint);
            }
            ColumnType type = columnDefinition.type();
            while (type instanceof CollectionColumnType) {
                CollectionColumnType collectionColumnType = (CollectionColumnType)type;
                type = collectionColumnType.innerType();
            }
            if (type instanceof ObjectColumnType) {
                ObjectColumnType objectColumnType = (ObjectColumnType)type;
                builder.columnPolicy = objectColumnType.columnPolicy().orElse(ColumnPolicy.DYNAMIC);
                for (ColumnDefinition nestedColumn : objectColumnType.nestedColumns()) {
                    nestedColumn.accept((AstVisitor)this, (Object)columnName);
                }
            }
            return null;
        }

        public Void visitPrimaryKeyConstraint(PrimaryKeyConstraint<?> node, ColumnIdent parent) {
            PrimaryKeyConstraint<?> pkConstraint = node;
            List pkColumns = pkConstraint.columns();
            for (Expression pk : pkColumns) {
                Symbol pkColumn = TableElementsAnalyzer.this.toSymbol.apply(pk);
                ColumnIdent columnIdent = pkColumn.toColumn();
                RefBuilder column = TableElementsAnalyzer.this.columns.get(columnIdent);
                if (column == null) {
                    throw new ColumnUnknownException(columnIdent, TableElementsAnalyzer.this.tableName);
                }
                TableElementsAnalyzer.this.markAsPrimaryKey(column, pkConstraint.constraintName());
            }
            return null;
        }

        public Void visitIndexDefinition(IndexDefinition<?> node, ColumnIdent parent) {
            IndexDefinition<?> indexDefinition = node;
            String name = indexDefinition.ident();
            ColumnIdent columnIdent = parent == null ? ColumnIdent.of(name) : ColumnIdent.getChildSafe(parent, name);
            RefBuilder builder = TableElementsAnalyzer.this.columns.get(columnIdent);
            builder.indexMethod = indexDefinition.method();
            builder.indexProperties = indexDefinition.properties().map(TableElementsAnalyzer.this.toSymbol);
            builder.indexSources = Lists.map((Collection)indexDefinition.columns(), TableElementsAnalyzer.this.toSymbol);
            builder.indexType = IndexType.of(builder.indexMethod);
            return null;
        }

        public Void visitCheckConstraint(CheckConstraint<?> node, ColumnIdent parent) {
            CheckConstraint<?> checkConstraint = node;
            Symbol checkSymbol = TableElementsAnalyzer.this.toSymbol.apply((Expression)checkConstraint.expression());
            TableElementsAnalyzer.this.addCheck(checkConstraint.name(), checkConstraint.expressionStr(), checkSymbol, null);
            return null;
        }
    }

    class PeekColumns
    extends DefaultTraversalVisitor<Void, Void> {
        PeekColumns() {
        }

        public Void visitColumnDefinition(ColumnDefinition<?> node, Void context) {
            ColumnDefinition<?> columnDefinition = node;
            ColumnType type = columnDefinition.type();
            ColumnIdent columnName = ColumnIdent.fromNameSafe(columnDefinition.ident(), List.of());
            DataType dataType = type == null ? DataTypes.UNDEFINED : DataTypeAnalyzer.convert(type);
            this.addColumn(columnName, dataType);
            return null;
        }

        public Void visitAddColumnDefinition(AddColumnDefinition<?> node, Void context) {
            assert (TableElementsAnalyzer.this.table != null) : "Must use CTOR that sets the DocTableInfo instance for ALTER TABLE ADD COLUMN";
            AddColumnDefinition<?> columnDefinition = node;
            Expression name = (Expression)columnDefinition.name();
            TableElementsAnalyzer.this.resolveMissing = true;
            Symbol columnSymbol = TableElementsAnalyzer.this.expressionAnalyzer.convert(name, TableElementsAnalyzer.this.expressionContext);
            TableElementsAnalyzer.this.resolveMissing = false;
            ColumnIdent columnName = columnSymbol.toColumn();
            for (ColumnIdent parent : columnName.parents()) {
                Reference parentRef = TableElementsAnalyzer.this.table.getReference(parent);
                if (parentRef != null) {
                    RefBuilder parentBuilder = new RefBuilder(parent, parentRef.valueType());
                    parentBuilder.builtReference = parentRef;
                    TableElementsAnalyzer.this.columns.put(parent, parentBuilder);
                    continue;
                }
                TableElementsAnalyzer.this.columns.computeIfAbsent(parent, columnIdent -> new RefBuilder(parent, ObjectType.UNTYPED));
            }
            Reference reference = TableElementsAnalyzer.this.table.getReference(columnName);
            if (reference != null) {
                throw new IllegalArgumentException("The table " + String.valueOf(TableElementsAnalyzer.this.tableName) + " already has a column named " + String.valueOf(columnName));
            }
            ColumnType type = columnDefinition.type();
            DataType dataType = type == null ? DataTypes.UNDEFINED : DataTypeAnalyzer.convert(type);
            this.addColumn(columnName, dataType);
            return null;
        }

        public Void visitIndexDefinition(IndexDefinition<?> node, Void context) {
            IndexDefinition<?> indexDefinition = node;
            String name = indexDefinition.ident();
            ColumnIdent columnName = ColumnIdent.fromNameSafe(name, List.of());
            this.addColumn(columnName, DataTypes.STRING);
            return null;
        }

        private void addColumn(ColumnIdent columnName, DataType<?> dataType) {
            RefBuilder builder = new RefBuilder(columnName, dataType);
            RefBuilder exists = TableElementsAnalyzer.this.columns.put(columnName, builder);
            if (exists != null) {
                throw new IllegalArgumentException("column \"" + columnName.sqlFqn() + "\" specified more than once");
            }
            if (TableElementsAnalyzer.this.table != null) {
                builder.builtReference = TableElementsAnalyzer.this.table.getReference(columnName);
            }
            while (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                dataType = arrayType.innerType();
            }
            if (dataType instanceof ObjectType) {
                ObjectType objectType = (ObjectType)dataType;
                for (Map.Entry<String, DataType<?>> entry : objectType.innerTypes().entrySet()) {
                    String childName = entry.getKey();
                    ColumnIdent childColumn = ColumnIdent.getChildSafe(columnName, childName);
                    DataType<?> childType = entry.getValue();
                    this.addColumn(childColumn, childType);
                }
            }
        }
    }

    public static class RefBuilder {
        private final ColumnIdent name;
        private DataType<?> type;
        private ColumnPolicy columnPolicy = ColumnPolicy.DYNAMIC;
        private IndexType indexType = IndexType.PLAIN;
        private RowGranularity rowGranularity = RowGranularity.DOC;
        private String indexMethod;
        private boolean nullable = true;
        private GenericProperties<Symbol> indexProperties = GenericProperties.empty();
        private boolean primaryKey;
        @Nullable
        private String pkConstraintName;
        private boolean explicitNullable;
        private Symbol generated;
        private Symbol defaultExpression;
        private GenericProperties<Symbol> storageProperties = GenericProperties.empty();
        private List<Symbol> indexSources = List.of();
        private Reference builtReference;

        RefBuilder(ColumnIdent name, DataType<?> type) {
            this.name = name;
            this.type = type;
        }

        @Nullable
        public String pkConstraintName() {
            return this.pkConstraintName;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isExplicitlyNull() {
            return this.explicitNullable;
        }

        public Reference build(Map<ColumnIdent, RefBuilder> columns, RelationName tableName, UnaryOperator<Symbol> bindParameter, Function<Symbol, Object> toValue) {
            Reference ref;
            if (this.builtReference != null) {
                return this.builtReference;
            }
            StorageSupport<?> storageSupport = this.type.storageSupportSafe();
            Symbol columnStoreSymbol = (Symbol)this.storageProperties.get(TableElementsAnalyzer.COLUMN_STORE_PROPERTY);
            if (!storageSupport.supportsDocValuesOff() && columnStoreSymbol != null) {
                throw new IllegalArgumentException("Invalid storage option \"columnstore\" for data type \"" + this.type.getName() + "\" for column: " + String.valueOf(this.name));
            }
            boolean hasDocValues = columnStoreSymbol == null ? storageSupport.getComputedDocValuesDefault(this.indexType) : DataTypes.BOOLEAN.implicitCast(toValue.apply(columnStoreSymbol)).booleanValue();
            ReferenceIdent refIdent = new ReferenceIdent(tableName, this.name);
            int position = -1;
            if (this.defaultExpression != null) {
                this.defaultExpression = (Symbol)bindParameter.apply(this.defaultExpression);
            }
            if (!this.indexSources.isEmpty() || this.indexType == IndexType.FULLTEXT || this.indexProperties.contains("analyzer")) {
                ArrayList<Reference> sources = new ArrayList<Reference>(this.indexSources.size());
                for (Symbol indexSource : this.indexSources) {
                    if (!ArrayType.unnest(indexSource.valueType()).equals(DataTypes.STRING)) {
                        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "INDEX source columns require `string` types. Cannot use `%s` (%s) as source for `%s`", indexSource.toColumn(), indexSource.valueType().getName(), this.name));
                    }
                    Reference source = (Reference)RefReplacer.replaceRefs((Symbol)bindParameter.apply(indexSource), x -> {
                        if (x instanceof DynamicReference) {
                            RefBuilder column = (RefBuilder)columns.get(x.column());
                            return column.build(columns, tableName, bindParameter, toValue);
                        }
                        return x;
                    });
                    if (Reference.indexOf(sources, source.column()) > -1) {
                        throw new IllegalArgumentException("Index " + String.valueOf(this.name) + " contains duplicate columns: " + String.valueOf(sources));
                    }
                    sources.add(source);
                }
                String analyzer = DataTypes.STRING.sanitizeValue(this.indexProperties.map(toValue).get("analyzer"));
                ref = new IndexReference(refIdent, this.rowGranularity, this.type, this.indexType, this.nullable, hasDocValues, position, Metadata.COLUMN_OID_UNASSIGNED, false, this.defaultExpression, sources, analyzer == null ? (this.indexType == IndexType.PLAIN ? "keyword" : "standard") : analyzer);
            } else if (ArrayType.unnest(this.type).id() == 14) {
                HashMap<String, Object> geoMap = new HashMap<String, Object>();
                GeoSettingsApplier.applySettings(geoMap, (GenericProperties<Object>)this.indexProperties.map(toValue), this.indexMethod);
                Float distError = (Float)geoMap.get("distance_error_pct");
                ref = new GeoReference(refIdent, this.type, this.indexType, this.nullable, position, Metadata.COLUMN_OID_UNASSIGNED, false, this.defaultExpression, this.indexMethod, (String)geoMap.get("precision"), (Integer)geoMap.get("tree_levels"), distError == null ? null : Double.valueOf(distError.doubleValue()));
            } else {
                ref = new SimpleReference(refIdent, this.rowGranularity, this.type, this.indexType, this.nullable, hasDocValues, position, Metadata.COLUMN_OID_UNASSIGNED, false, this.defaultExpression);
            }
            if (this.generated != null) {
                this.generated = RefReplacer.replaceRefs((Symbol)bindParameter.apply(this.generated), x -> {
                    if (x instanceof DynamicReference) {
                        DynamicReference dynamicRef = (DynamicReference)x;
                        RefBuilder column = (RefBuilder)columns.get(dynamicRef.column());
                        x = column.build(columns, tableName, bindParameter, toValue);
                    }
                    if (x instanceof GeneratedReference) {
                        throw new ColumnValidationException(this.name.sqlFqn(), tableName, "Generated column cannot be based on generated column `" + String.valueOf(x.column()) + "`");
                    }
                    return x;
                });
                ref = new GeneratedReference(ref, this.generated);
            }
            this.builtReference = ref;
            return ref;
        }

        public void visitSymbols(Consumer<? super Symbol> consumer) {
            if (this.defaultExpression != null) {
                consumer.accept(this.defaultExpression);
            }
            if (this.generated != null) {
                consumer.accept(this.generated);
            }
            this.indexProperties.forValues(consumer);
            this.storageProperties.forValues(consumer);
        }
    }
}

