/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.FrameBoundDefinition;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.sql.tree.FrameBound;
import io.crate.sql.tree.WindowFrame;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public class WindowFrameDefinition
implements Writeable {
    private final WindowFrame.Mode mode;
    private final FrameBoundDefinition start;
    private final FrameBoundDefinition end;

    public WindowFrameDefinition(StreamInput in) throws IOException {
        this.mode = in.readEnum(WindowFrame.Mode.class);
        this.start = new FrameBoundDefinition(in);
        this.end = in.readOptionalWriteable(FrameBoundDefinition::new);
    }

    public WindowFrameDefinition(WindowFrame.Mode mode, FrameBoundDefinition start, @Nullable FrameBoundDefinition end) {
        this.mode = mode;
        this.start = start;
        this.end = end != null ? end : new FrameBoundDefinition(FrameBound.Type.CURRENT_ROW, Literal.NULL);
    }

    public WindowFrame.Mode mode() {
        return this.mode;
    }

    public FrameBoundDefinition start() {
        return this.start;
    }

    public FrameBoundDefinition end() {
        return this.end;
    }

    public WindowFrameDefinition map(Function<? super Symbol, ? extends Symbol> mapper) {
        FrameBoundDefinition newStart = this.start.map(mapper);
        FrameBoundDefinition newEnd = this.end.map(mapper);
        if (newStart == this.start && newEnd == this.end) {
            return this;
        }
        return new WindowFrameDefinition(this.mode, newStart, newEnd);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.mode);
        this.start.writeTo(out);
        out.writeOptionalWriteable(this.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowFrameDefinition that = (WindowFrameDefinition)o;
        return this.mode == that.mode && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.start, this.end);
    }

    public String toString() {
        return "WindowFrame{type=" + String.valueOf(this.mode) + ", start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + "}";
    }
}

