/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.ddl;

import io.crate.sql.tree.GenericProperties;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.DistanceUnit;
import org.jetbrains.annotations.Nullable;

public final class GeoSettingsApplier {
    private static final Set<String> SUPPORTED_OPTIONS = Set.of("precision", "distance_error_pct", "tree_levels");

    private GeoSettingsApplier() {
    }

    public static void applySettings(Map<String, Object> mapping, GenericProperties<Object> properties, @Nullable String geoTree) {
        Settings geoSettings = Settings.builder().put(properties).build();
        GeoSettingsApplier.validate(geoSettings);
        if (geoTree != null) {
            mapping.put("tree", geoTree);
        }
        GeoSettingsApplier.applyPrecision(mapping, geoSettings);
        GeoSettingsApplier.applyDistanceErrorPct(mapping, geoSettings);
    }

    private static void applyDistanceErrorPct(Map<String, Object> mapping, Settings geoSettings) {
        try {
            Float errorPct = geoSettings.getAsFloat("distance_error_pct", null);
            if (errorPct != null) {
                mapping.put("distance_error_pct", errorPct);
            }
        }
        catch (SettingsException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Value '%s' of setting distance_error_pct is not a float value", geoSettings.get("distance_error_pct")));
        }
    }

    private static void applyPrecision(Map<String, Object> mapping, Settings geoSettings) {
        String precision = geoSettings.get("precision");
        if (precision == null) {
            Integer treeLevels = geoSettings.getAsInt("tree_levels", null);
            if (treeLevels != null) {
                mapping.put("tree_levels", treeLevels);
            }
        } else {
            try {
                DistanceUnit.parse(precision, DistanceUnit.DEFAULT, DistanceUnit.DEFAULT);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Value '%s' of setting precision is not a valid distance unit", precision));
            }
            mapping.put("precision", precision);
        }
    }

    private static void validate(Settings geoSettings) {
        for (String setting : geoSettings.names()) {
            if (SUPPORTED_OPTIONS.contains(setting)) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Setting \"%s\" ist not supported on geo_shape index", setting));
        }
    }
}

