/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.expressions;

import io.crate.metadata.settings.SessionSettings;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.DefaultTraversalVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.SubqueryExpression;
import io.crate.sql.tree.Window;
import java.util.IdentityHashMap;
import java.util.Map;

public class ExpressionAnalysisContext {
    private final ArrayChildVisitor arrayChildVisitor = new ArrayChildVisitor();
    private final Map<SubqueryExpression, Object> arrayExpressionsChildren = new IdentityHashMap<SubqueryExpression, Object>();
    private boolean hasAggregates;
    private boolean allowEagerNormalize = true;
    private boolean parentIsOrderSensitive = true;
    private final boolean errorOnUnknownObjectKey;
    private Map<String, Window> windows = Map.of();

    public ExpressionAnalysisContext(SessionSettings sessionSettings) {
        this.errorOnUnknownObjectKey = sessionSettings.errorOnUnknownObjectKey();
    }

    void indicateAggregates() {
        this.hasAggregates = true;
    }

    public boolean hasAggregates() {
        return this.hasAggregates;
    }

    public boolean isEagerNormalizationAllowed() {
        return this.allowEagerNormalize;
    }

    public void allowEagerNormalize(boolean value) {
        this.allowEagerNormalize = value;
    }

    public boolean parentIsOrderSensitive() {
        return this.parentIsOrderSensitive;
    }

    public void parentIsOrderSensitive(boolean parentIsOrderSensitive) {
        this.parentIsOrderSensitive = parentIsOrderSensitive;
    }

    public void windows(Map<String, Window> windows) {
        this.windows = windows;
    }

    public Map<String, Window> windows() {
        return this.windows;
    }

    public boolean errorOnUnknownObjectKey() {
        return this.errorOnUnknownObjectKey;
    }

    void registerArrayChild(Expression arrayExpressionChild) {
        arrayExpressionChild.accept((AstVisitor)this.arrayChildVisitor, null);
    }

    boolean isArrayChild(SubqueryExpression expression) {
        return this.arrayExpressionsChildren.containsKey(expression);
    }

    private class ArrayChildVisitor
    extends DefaultTraversalVisitor<Void, Void> {
        private ArrayChildVisitor() {
        }

        protected Void visitSubqueryExpression(SubqueryExpression node, Void context) {
            ExpressionAnalysisContext.this.arrayExpressionsChildren.put(node, null);
            return null;
        }
    }
}

