/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.auth.AuthSettings;
import io.crate.auth.Authentication;
import io.crate.auth.AuthenticationMethod;
import io.crate.auth.ClientCertAuth;
import io.crate.auth.JWTAuthenticationMethod;
import io.crate.auth.PasswordAuthenticationMethod;
import io.crate.auth.Protocol;
import io.crate.auth.TrustAuthenticationMethod;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.role.Roles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.Cidrs;
import org.elasticsearch.common.network.DnsResolver;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class HostBasedAuthentication
implements Authentication {
    private static final Logger LOGGER = LogManager.getLogger(HostBasedAuthentication.class);
    private SortedMap<String, HBAConf> hbaConf;
    private final Roles roles;
    private final DnsResolver dnsResolver;
    private final JWTAuthenticationMethod jwtMethod;

    public HostBasedAuthentication(Settings settings, Roles roles, DnsResolver dnsResolver, Supplier<String> clusterId) {
        this.hbaConf = this.convertHbaSettingsToHbaConf(settings);
        this.roles = roles;
        this.dnsResolver = dnsResolver;
        this.jwtMethod = new JWTAuthenticationMethod(roles, settings, clusterId);
    }

    @VisibleForTesting
    SortedMap<String, HBAConf> convertHbaSettingsToHbaConf(Settings settings) {
        Settings hbaSettings = AuthSettings.AUTH_HOST_BASED_CONFIG_SETTING.get(settings);
        TreeMap<String, HBAConf> hostBasedConf = new TreeMap<String, HBAConf>();
        for (Map.Entry<String, Settings> entry : hbaSettings.getAsGroups().entrySet()) {
            hostBasedConf.put(entry.getKey(), HBAConf.parse(entry.getValue()));
        }
        return Collections.unmodifiableSortedMap(hostBasedConf);
    }

    @Nullable
    private AuthenticationMethod methodForName(String method) {
        return switch (method) {
            case "trust" -> new TrustAuthenticationMethod(this.roles);
            case "cert" -> new ClientCertAuth(this.roles);
            case "password" -> new PasswordAuthenticationMethod(this.roles);
            case "jwt" -> this.jwtMethod;
            default -> null;
        };
    }

    @Override
    @Nullable
    public AuthenticationMethod resolveAuthenticationType(@Nullable String user, ConnectionProperties connProperties) {
        assert (this.hbaConf != null) : "hba configuration is missing";
        Optional<Map.Entry<String, HBAConf>> entry = this.getEntry(user, connProperties);
        if (entry.isPresent()) {
            String methodName = entry.get().getValue().method();
            return this.methodForName(methodName);
        }
        return null;
    }

    @VisibleForTesting
    Map<String, HBAConf> hbaConf() {
        return this.hbaConf;
    }

    @VisibleForTesting
    Optional<Map.Entry<String, HBAConf>> getEntry(@Nullable String user, ConnectionProperties connectionProperties) {
        if (user == null || connectionProperties == null) {
            return Optional.empty();
        }
        return this.hbaConf.entrySet().stream().filter(e -> Matchers.isValidUser(e, user)).filter(e -> Matchers.isValidAddress(((HBAConf)e.getValue()).address(), connectionProperties.address(), this.dnsResolver)).filter(e -> Matchers.isValidProtocol(((HBAConf)e.getValue()).protocol(), connectionProperties.protocol())).filter(e -> Matchers.isValidConnection(((HBAConf)e.getValue()).ssl(), connectionProperties)).filter(e -> Matchers.isValidMethod(((HBAConf)e.getValue()).method(), connectionProperties.clientMethods())).findFirst();
    }

    record HBAConf(String method, SSL ssl, @Nullable String user, @Nullable String address, @Nullable String protocol) {
        private static final String DEFAULT_AUTH_METHOD = "trust";
        private static final String KEY_USER = "user";
        private static final String KEY_ADDRESS = "address";
        private static final String KEY_METHOD = "method";
        private static final String KEY_PROTOCOL = "protocol";

        HBAConf(String method, SSL ssl, @Nullable String user, @Nullable String address, @Nullable String protocol) {
            if ("jwt".equals(method) && !Protocol.HTTP.toString().equals(protocol)) {
                throw new IllegalArgumentException("protocol must be set to http when using jwt auth method");
            }
        }

        public static HBAConf parse(Settings settings) {
            return new HBAConf(settings.get(KEY_METHOD, DEFAULT_AUTH_METHOD), SSL.parseValue(settings.get("ssl", "optional")), settings.get(KEY_USER), settings.get(KEY_ADDRESS), settings.get(KEY_PROTOCOL));
        }
    }

    static class Matchers {
        private static final long IPV4_LOCALHOST = Matchers.inetAddressToInt(InetAddresses.forString("127.0.0.1"));
        private static final long IPV6_LOCALHOST = Matchers.inetAddressToInt(InetAddresses.forString("::1"));

        Matchers() {
        }

        static boolean isValidUser(Map.Entry<String, HBAConf> entry, String user) {
            String hbaUser = entry.getValue().user();
            return hbaUser == null || user.equals(hbaUser);
        }

        static boolean isValidAddress(@Nullable String hbaAddressOrHostname, long address, Supplier<String> getHostname, DnsResolver resolver) {
            if (hbaAddressOrHostname == null) {
                return true;
            }
            if (hbaAddressOrHostname.equals("_local_")) {
                return address == IPV4_LOCALHOST || address == IPV6_LOCALHOST;
            }
            int p = hbaAddressOrHostname.indexOf(47);
            if (p < 0) {
                try {
                    if (hbaAddressOrHostname.startsWith(".")) {
                        String clientHostName = getHostname.get();
                        return clientHostName != null && clientHostName.endsWith(hbaAddressOrHostname);
                    }
                    for (InetAddress resolvedAddress : resolver.resolve(hbaAddressOrHostname)) {
                        if (Matchers.inetAddressToInt(resolvedAddress) != address) continue;
                        return true;
                    }
                    return false;
                }
                catch (UnknownHostException e) {
                    LOGGER.warn("Cannot resolve hostname {} specified in the HBA configuration.", (Object)hbaAddressOrHostname);
                    return false;
                }
            }
            long[] minAndMax = Cidrs.cidrMaskToMinMax(hbaAddressOrHostname);
            return minAndMax[0] <= address && address < minAndMax[1];
        }

        static boolean isValidAddress(@Nullable String hbaAddressOrHostname, InetAddress address, DnsResolver resolver) {
            return Matchers.isValidAddress(hbaAddressOrHostname, Matchers.inetAddressToInt(address), address::getCanonicalHostName, resolver);
        }

        static boolean isValidProtocol(String hbaProtocol, Protocol protocol) {
            return hbaProtocol == null || hbaProtocol.equals(protocol.toString());
        }

        static boolean isValidConnection(SSL sslMode, ConnectionProperties connectionProperties) {
            return switch (sslMode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> true;
                case 1 -> {
                    if (!connectionProperties.hasSSL()) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> connectionProperties.hasSSL();
            };
        }

        static boolean isValidMethod(@Nullable String method, List<ConnectionProperties.ClientMethod> clientMethods) {
            if (method == null) {
                return true;
            }
            for (ConnectionProperties.ClientMethod clientMethod : clientMethods) {
                if (!clientMethod.toString().equalsIgnoreCase(method)) continue;
                return true;
            }
            return false;
        }

        static long inetAddressToInt(InetAddress address) {
            long net = 0L;
            for (byte a : address.getAddress()) {
                net <<= 8;
                net |= (long)(a & 0xFF);
            }
            return net;
        }
    }

    static enum SSL {
        REQUIRED("on"),
        NEVER("off"),
        OPTIONAL("optional");

        static final String KEY = "ssl";
        final String VALUE;

        private SSL(String value) {
            this.VALUE = value;
        }

        static SSL parseValue(String value) {
            return switch (value.toLowerCase(Locale.ENGLISH)) {
                case "on" -> REQUIRED;
                case "true" -> REQUIRED;
                case "off" -> NEVER;
                case "false" -> NEVER;
                case "optional" -> OPTIONAL;
                default -> throw new IllegalArgumentException(value + " is not a valid HBA SSL setting");
            };
        }
    }
}

